/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MorphologyOperator implements Enumerator
{
    ERODE(0, "erode", "erode"),
    DILATE(1, "dilate", "dilate");

    public static final int ERODE_VALUE = 0;
    public static final int DILATE_VALUE = 1;
    private static final MorphologyOperator[] VALUES_ARRAY;
    public static final List<MorphologyOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MorphologyOperator[]{ERODE, DILATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MorphologyOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MorphologyOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MorphologyOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MorphologyOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MorphologyOperator get(int value) {
        switch (value) {
            case 0: {
                return ERODE;
            }
            case 1: {
                return DILATE;
            }
        }
        return null;
    }

    private MorphologyOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

