/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.text;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.eclipse.fx.core.Subscription;

public class AbstractTextRegistry<M> {
    private M messages;
    Map<Consumer<String>, Supplier<String>> bindings = new HashMap<Consumer<String>, Supplier<String>>();

    public final M getMessages() {
        return this.messages;
    }

    public Subscription register(Consumer<String> consumer, Function<M, String> valueFunction) {
        return this.register(consumer, () -> (String)valueFunction.apply(this.getMessages()));
    }

    public Subscription register(final Consumer<String> consumer, Supplier<String> supplier) {
        this.bindings.put(consumer, supplier);
        consumer.accept(supplier.get());
        return new Subscription(){

            @Override
            public void dispose() {
                AbstractTextRegistry.this.bindings.remove(consumer);
            }
        };
    }

    public void updateMessages(M messages) {
        this.messages = messages;
        for (Map.Entry<Consumer<String>, Supplier<String>> next : this.bindings.entrySet()) {
            next.getKey().accept(next.getValue().get());
        }
    }

    @PreDestroy
    void unregister() {
        this.bindings.clear();
    }
}

