/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LinkedPositionGroup {
    public static final int NO_STOP = -1;
    private final List<LinkedPosition> fPositions = new LinkedList<LinkedPosition>();
    private boolean fIsSealed = false;
    private boolean fHasCustomIteration = false;
    private LinkedPosition fLastPosition;
    private IRegion fLastRegion;
    private boolean fMustEnforceEqualContents = false;

    public void addPosition(LinkedPosition position) throws BadLocationException {
        Assert.isNotNull((Object)position);
        if (this.fIsSealed) {
            throw new IllegalStateException("cannot add positions after the group is added to an model");
        }
        if (!this.fPositions.contains(position)) {
            this.enforceDisjoint(position);
            this.checkContent(position);
            this.fPositions.add(position);
            this.fHasCustomIteration |= position.getSequenceNumber() != -1;
        } else {
            return;
        }
    }

    private void checkContent(LinkedPosition position) throws BadLocationException {
        if (this.fPositions.size() > 0) {
            LinkedPosition groupPosition = this.fPositions.get(0);
            String groupContent = groupPosition.getContent();
            String positionContent = position.getContent();
            if (!this.fMustEnforceEqualContents && !groupContent.equals(positionContent)) {
                this.fMustEnforceEqualContents = true;
            }
        }
    }

    private void enforceDisjoint(LinkedPosition position) throws BadLocationException {
        for (LinkedPosition p : this.fPositions) {
            if (!p.overlapsWith(position)) continue;
            throw new BadLocationException();
        }
    }

    void enforceDisjoint(LinkedPositionGroup group) throws BadLocationException {
        Assert.isNotNull((Object)group);
        for (LinkedPosition p : group.fPositions) {
            this.enforceDisjoint(p);
        }
    }

    boolean isLegalEvent(DocumentEvent event) {
        this.fLastPosition = null;
        this.fLastRegion = null;
        for (LinkedPosition pos : this.fPositions) {
            if (!this.overlapsOrTouches(pos, event)) continue;
            if (this.fLastPosition != null) {
                this.fLastPosition = null;
                this.fLastRegion = null;
                return false;
            }
            this.fLastPosition = pos;
            this.fLastRegion = new Region(pos.getOffset(), pos.getLength());
        }
        return true;
    }

    private boolean overlapsOrTouches(LinkedPosition position, DocumentEvent event) {
        return position.getDocument().equals(event.getDocument()) && position.getOffset() <= event.getOffset() + event.getLength() && position.getOffset() + position.getLength() >= event.getOffset();
    }

    Map<IDocument, TextEdit> handleEvent(DocumentEvent event) {
        if (this.fLastPosition != null) {
            int lastEnd;
            int eventEnd;
            HashMap map = new HashMap();
            int relativeOffset = event.getOffset() - this.fLastRegion.getOffset();
            if (relativeOffset < 0) {
                relativeOffset = 0;
            }
            int length = (eventEnd = event.getOffset() + event.getLength()) > (lastEnd = this.fLastRegion.getOffset() + this.fLastRegion.getLength()) ? lastEnd - relativeOffset - this.fLastRegion.getOffset() : eventEnd - relativeOffset - this.fLastRegion.getOffset();
            String text = event.getText();
            if (text == null) {
                text = "";
            }
            for (LinkedPosition p : this.fPositions) {
                if (p == this.fLastPosition || p.isDeleted()) continue;
                ArrayList<ReplaceEdit> edits = (ArrayList<ReplaceEdit>)map.get(p.getDocument());
                if (edits == null) {
                    edits = new ArrayList<ReplaceEdit>();
                    map.put(p.getDocument(), edits);
                }
                if (this.fMustEnforceEqualContents) {
                    try {
                        edits.add(new ReplaceEdit(p.getOffset(), p.getLength(), this.fLastPosition.getContent()));
                        continue;
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
                edits.add(new ReplaceEdit(p.getOffset() + relativeOffset, length, text));
            }
            this.fMustEnforceEqualContents = false;
            try {
                HashMap<IDocument, TextEdit> result = new HashMap<IDocument, TextEdit>();
                for (Map.Entry edits : map.entrySet()) {
                    MultiTextEdit edit = new MultiTextEdit(0, ((IDocument)edits.getKey()).getLength());
                    edit.addChildren(((List)edits.getValue()).toArray(new TextEdit[((List)edits.getValue()).size()]));
                    result.put((IDocument)edits.getKey(), edit);
                }
                return result;
            }
            catch (MalformedTreeException malformedTreeException) {
                return null;
            }
        }
        return null;
    }

    void seal() {
        Assert.isTrue((!this.fIsSealed ? 1 : 0) != 0);
        this.fIsSealed = true;
        if (!this.fHasCustomIteration && this.fPositions.size() > 0) {
            this.fPositions.get(0).setSequenceNumber(0);
        }
    }

    IDocument[] getDocuments() {
        IDocument[] docs = new IDocument[this.fPositions.size()];
        int i = 0;
        for (LinkedPosition pos : this.fPositions) {
            docs[i] = pos.getDocument();
            ++i;
        }
        return docs;
    }

    void register(LinkedModeModel model) throws BadLocationException {
        for (LinkedPosition pos : this.fPositions) {
            model.register(pos);
        }
    }

    LinkedPosition adopt(LinkedPositionGroup group) throws BadLocationException {
        LinkedPosition found = null;
        for (LinkedPosition pos : group.fPositions) {
            LinkedPosition localFound = null;
            for (LinkedPosition myPos : this.fPositions) {
                if (!myPos.includes(pos)) continue;
                if (found == null) {
                    found = myPos;
                } else if (found != myPos) {
                    throw new BadLocationException();
                }
                if (localFound != null) continue;
                localFound = myPos;
            }
            if (localFound == found) continue;
            throw new BadLocationException();
        }
        return found;
    }

    LinkedPosition getPosition(LinkedPosition toFind) {
        for (LinkedPosition p : this.fPositions) {
            if (!p.includes(toFind)) continue;
            return p;
        }
        return null;
    }

    boolean contains(int offset) {
        for (LinkedPosition pos : this.fPositions) {
            if (!pos.includes(offset)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.fPositions.size() == 0;
    }

    @Deprecated
    public boolean isEmtpy() {
        return this.isEmpty();
    }

    public LinkedPosition[] getPositions() {
        return this.fPositions.toArray(new LinkedPosition[0]);
    }

    boolean contains(Position position) {
        for (LinkedPosition p : this.fPositions) {
            if (!position.equals(p)) continue;
            return true;
        }
        return false;
    }
}

