/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.tests.common.webclient.TestFailureException;
import com.sun.ts.tests.common.webclient.validation.CheckOneOfStatusesTokenizedValidator;
import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketTestCase;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;

@Tags(value={@Tag(value="websocket"), @Tag(value="platform"), @Tag(value="web")})
public abstract class WebSocketCommonClient {
    private static final System.Logger logger = System.getLogger(WebSocketCommonClient.class.getName());
    private static final long serialVersionUID = 1L;
    boolean isTestCaseAfterInvocation;
    @ArquillianResource
    @OperateOnDeployment(value="_DEFAULT_")
    protected URL url;
    protected static final String SERVLETHOSTPROP = "webServerHost";
    protected static final String SERVLETPORTPROP = "webServerPort";
    protected static final String WSWAIT = "ws_wait";
    protected Hashtable<Property, String> TEST_PROPS;
    protected String _contextRoot = null;
    protected String _hostname = null;
    protected int _port = 0;
    protected String requestProtocol = "ws";
    protected int _ws_wait = 0;
    protected WebSocketTestCase testCase;
    protected boolean logExceptionOnInvoke = true;
    protected Entity entity;

    public String getContextRoot() {
        return this._contextRoot;
    }

    public void setContextRoot(String root) {
        logger.log(System.Logger.Level.TRACE, "[WebSocketCommonClient] Contextroot set at " + root);
        this._contextRoot = root;
    }

    protected void setProperty(Property key, String ... values) {
        for (String singleValue : values) {
            this.setProperty(key, singleValue);
        }
    }

    protected void setProperty(Property key, String value) {
        switch (key.ordinal()) {
            case 2: {
                this.setEntity(value);
                break;
            }
            default: {
                String oldValue = this.TEST_PROPS.get((Object)key);
                if (oldValue == null) {
                    this.TEST_PROPS.put(key, value);
                    break;
                }
                int len = value.length() + oldValue.length() + 1;
                StringBuilder combinedValue = new StringBuilder(len);
                combinedValue.append(oldValue).append("|").append(value);
                this.TEST_PROPS.put(key, combinedValue.toString());
            }
        }
    }

    protected String buildRequest(String ... path) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAbsoluteUrl()).append("/");
        for (String segment : path) {
            sb.append(segment);
        }
        return sb.toString();
    }

    protected String getAbsoluteUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requestProtocol).append("://").append(this._hostname).append(":").append(this._port).append("/").append(this.getContextRoot());
        return sb.toString();
    }

    protected <T extends Enum<T>> void invoke(String endpoint, Enum<T> content, Enum<T> search) throws Exception {
        this.invoke(endpoint, (Object)content.name(), search.name());
    }

    protected void invoke(String endpoint, Enum<?> content, String ... search) throws Exception {
        this.invoke(endpoint, (Object)content.name(), search);
    }

    protected void invoke(String endpoint, Object content, String ... search) throws Exception {
        this.invoke(endpoint, content, search, true);
    }

    protected void invoke(String endpoint, Object content, String[] search, boolean cleanup) throws Exception {
        this.setProperty(Property.REQUEST, this.buildRequest(endpoint));
        this.setEntity(content);
        this.setProperty(Property.SEARCH_STRING, search);
        this.invoke(cleanup);
    }

    protected void invoke(String endpoint, Object content, String search, boolean cleanup) throws Exception {
        this.invoke(endpoint, content, new String[]{search}, cleanup);
    }

    protected void invokeAgain(Object content, String search, boolean cleanup) throws Exception {
        this.setEntity(content);
        this.setProperty(Property.SEARCH_STRING, search);
        this.invokeAgain(cleanup);
    }

    protected void invoke() throws Exception {
        this.invoke(true);
    }

    protected void invoke(boolean cleanUp) throws Exception {
        this.invoke(cleanUp, false);
    }

    protected void invokeAgain(boolean cleanUp) throws Exception {
        this.invoke(cleanUp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(boolean cleanUp, boolean again) throws Exception {
        logger.log(System.Logger.Level.TRACE, "[WebSocketCommonClient] invoke");
        logger.log(System.Logger.Level.TRACE, "[WebSocketCommonClient] EXECUTING");
        this.setTestProperties(this.getTestCase());
        try {
            this.executeTestCase(again);
            this.testCase.validate();
            this.assertCountDownLatchCount();
        }
        catch (TestFailureException tfe) {
            this.dealWithTestFailureException(tfe);
        }
        finally {
            this.isTestCaseAfterInvocation = cleanUp;
            if (cleanUp) {
                this.cleanup();
            }
        }
    }

    protected void executeTestCase(boolean again) throws TestFailureException, Exception {
        if (again) {
            this.testCase.newCountDown();
            SendMessageCallback callback = new SendMessageCallback(this.entity);
            callback.onOpen(this.getSession(), null);
            this.testCase.awaitCountDown();
        } else {
            this.testCase.execute();
        }
    }

    private void dealWithTestFailureException(TestFailureException tfe) throws Exception {
        Throwable t = tfe.getRootCause();
        if (t != null && this.logExceptionOnInvoke) {
            logger.log(System.Logger.Level.ERROR, "Root cause of Failure: " + t.getMessage(), t);
        } else {
            this.logExceptionOnInvoke = true;
        }
        throw new Exception(tfe.getMessage() + "[WebSocketCommonClient] TestCase failed!  Check output for cause of failure.", t);
    }

    protected void setTestProperties(WebSocketTestCase testCase) {
        logger.log(System.Logger.Level.TRACE, "[WebSocketCommonClient] setTestProperties");
        if (this.TEST_PROPS.get((Object)Property.STATUS_CODE) == null) {
            this.setProperty(Property.STATUS_CODE, "200");
        }
        this.setWebTestCaseProperties(testCase);
    }

    protected void setWebTestCaseProperties(WebSocketTestCase testCase) {
        Property key = null;
        String value = null;
        Enumeration<Property> e = this.TEST_PROPS.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = this.TEST_PROPS.get((Object)key);
            switch (key.ordinal()) {
                case 1: {
                    break;
                }
                case 0: {
                    final String user = this.TEST_PROPS.get((Object)Property.BASIC_AUTH_USER);
                    final String password = this.TEST_PROPS.get((Object)Property.BASIC_AUTH_PASSWD);
                    ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

                        public void beforeRequest(Map<String, List<String>> headers) {
                            headers.putAll(WebSocketCommonClient.basicAuthenticationAsHeaderMap(user, password));
                            super.beforeRequest(headers);
                        }
                    };
                    this.addClientConfigurator(configurator);
                    break;
                }
                case 2: {
                    this.setEntity(value);
                    break;
                }
                case 3: {
                    testCase.addExpectedHeader(value);
                    this.TEST_PROPS.remove((Object)Property.EXPECTED_HEADERS);
                    break;
                }
                case 4: {
                    testCase.setExpectedStatusCode("-1");
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    value = testCase.getTextCaser().getCasedText(value);
                    testCase.setResponseSearchString(value);
                    this.TEST_PROPS.remove((Object)Property.SEARCH_STRING);
                    break;
                }
                case 7: {
                    testCase.setResponseSearchStringIgnoreCase(value);
                    this.TEST_PROPS.remove((Object)Property.SEARCH_STRING_IGNORE_CASE);
                    break;
                }
                case 8: {
                    if (value.contains("|")) {
                        testCase.setStrategy(CheckOneOfStatusesTokenizedValidator.class.getName());
                    }
                    testCase.setExpectedStatusCode(value);
                    break;
                }
                case 9: {
                    testCase.addUnexpectedHeader(value);
                    this.TEST_PROPS.remove((Object)Property.UNEXPECTED_HEADERS);
                    break;
                }
                case 10: {
                    testCase.setUnexpectedResponseSearchString(value);
                    this.TEST_PROPS.remove((Object)Property.UNEXPECTED_RESPONSE_MATCH);
                    break;
                }
                case 11: {
                    value = testCase.getTextCaser().getCasedText(value);
                    testCase.setUnorderedSearchString(value);
                    this.TEST_PROPS.remove((Object)Property.UNORDERED_SEARCH_STRING);
                }
            }
        }
    }

    protected WebSocketTestCase getTestCase() {
        if (this.testCase == null || this.isTestCaseAfterInvocation) {
            this.testCase = new WebSocketTestCase(this);
            this.isTestCaseAfterInvocation = false;
        }
        return this.testCase;
    }

    protected <MSGTYPE> void setEndPointCase(Class<ClientEndpoint<MSGTYPE>> endpoint) {
        this.getTestCase().setClientEndpoint(endpoint);
    }

    protected Entity setEntity(Object ... partials) {
        this.entity = new Entity(partials);
        return this.entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterEach
    public void cleanup() throws Exception {
        this.TEST_PROPS.clear();
        this.isTestCaseAfterInvocation = true;
        if (this.testCase != null && this.testCase.session != null) {
            if (this.testCase.session.isOpen()) {
                ClientEndpoint.ClientEndpointData.newOnCloseCountDown();
                WebSocketCommonClient.logTrace("[WebSocketCommonClient] session.close() on session id", this.testCase.session.getId());
                this.testCase.session.close();
                ClientEndpoint.ClientEndpointData.awaitOnClose();
            }
            this.testCase.session = null;
        }
        Object object = ClientEndpoint.ClientEndpointData.LOCK;
        synchronized (object) {
            ClientEndpoint.ClientEndpointData.callback = null;
        }
        logger.log(System.Logger.Level.DEBUG, "[WebSocketCommonClient] Test cleanup OK");
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup method WebSocketCommonClient");
        String hostname = System.getProperty(SERVLETHOSTPROP);
        String portnum = System.getProperty(SERVLETPORTPROP);
        hostname = WebSocketCommonClient.isNullOrEmpty(hostname) ? this.url.getHost() : hostname;
        portnum = WebSocketCommonClient.isNullOrEmpty(portnum) ? Integer.toString(this.url.getPort()) : portnum;
        String wswait = System.getProperty(WSWAIT);
        WebSocketCommonClient.assertFalse(WebSocketCommonClient.isNullOrEmpty(hostname), "[WebSocketCommonClient] 'webServerHost' was not set.");
        this._hostname = hostname.trim();
        WebSocketCommonClient.assertFalse(WebSocketCommonClient.isNullOrEmpty(portnum), "[WebSocketCommonClient] 'webServerPort' was not set.");
        this._port = Integer.parseInt(portnum.trim());
        WebSocketCommonClient.assertFalse(WebSocketCommonClient.isNullOrEmpty(wswait), "[WebSocketCommonClient] 'ws_wait' must be set in the properties");
        this._ws_wait = Integer.parseInt(wswait.trim());
        WebSocketCommonClient.assertTrue(this._ws_wait > 0, "[WebSocketCommonClient] 'ws_wait' (in seconds) must be set greater than 0");
        logger.log(System.Logger.Level.DEBUG, "[WebSocketCommonClient] Test setup OK");
        this.TEST_PROPS = new Hashtable();
    }

    protected void assertCountDownLatchCount() throws Exception {
        long hits = this.testCase.getCountDownLatchRemainingHits();
        int count = this.testCase.getCountDownLatchTotalCount();
        WebSocketCommonClient.assertEqualsLong(0L, hits, "The countDownLatch has been hit only", (long)count - hits, "was expected", count, "times");
        WebSocketCommonClient.logTrace("[WebSocketCommonClient] CountDownLatch has been hit", count, "times as expected");
    }

    public static void assertTrue(boolean condition, Object ... message) throws Exception {
        if (!condition) {
            throw new Exception(WebSocketCommonClient.objectsToString(message));
        }
    }

    public static void assertFalse(boolean condition, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(!condition, message);
    }

    public static <T> void assertEquals(T first, T second, Object ... message) throws Exception {
        if (first == null && second == null) {
            return;
        }
        WebSocketCommonClient.assertFalse(first == null && second != null, message);
        WebSocketCommonClient.assertFalse(first != null && second == null, message);
        if (first instanceof Comparable) {
            WebSocketCommonClient.assertTrue(((Comparable)first).compareTo(second) == 0, message);
        } else {
            WebSocketCommonClient.assertTrue(first.equals(second), message);
        }
    }

    public static <T> void assertEqualsInt(int first, int second, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(first == second, message);
    }

    public static <T> void assertEqualsLong(long first, long second, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(first == second, message);
    }

    public static <T> void assertEqualsBool(boolean first, boolean second, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(first == second, message);
    }

    public static void assertNull(Object object, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(object == null, message);
    }

    public static void assertNotNull(Object object, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(object != null, message);
    }

    public static void assertContains(String string, String substring, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(string.contains(substring), message);
    }

    public static void assertContainsIgnoreCase(String string, String substring, Object ... message) throws Exception {
        WebSocketCommonClient.assertTrue(string.toLowerCase().contains(substring.toLowerCase()), message);
    }

    public static void assertNotContains(String string, String substring, Object ... message) throws Exception {
        WebSocketCommonClient.assertFalse(string.contains(substring), message);
    }

    public static void assertNotContainsIgnoreCase(String string, String substring, Object ... message) throws Exception {
        WebSocketCommonClient.assertFalse(string.toLowerCase().contains(substring.toLowerCase()), message);
    }

    public static <T> void assertContains(T text, T subtext, Object ... message) throws Exception {
        WebSocketCommonClient.assertContains(text.toString(), subtext.toString(), message);
    }

    public static <T> void assertContainsIgnoreCase(T text, T subtext, Object ... message) throws Exception {
        WebSocketCommonClient.assertContainsIgnoreCase(text.toString(), subtext.toString(), message);
    }

    public static String assertProperty(Properties p, String propertyName) throws Exception {
        String value = System.getProperty(propertyName);
        WebSocketCommonClient.logTrace(propertyName, value);
        WebSocketCommonClient.assertTrue(!WebSocketCommonClient.isNullOrEmpty(value), propertyName, "was not set in build.properties");
        return value;
    }

    protected static <T extends Throwable> T assertCause(Throwable parent, Class<T> wrapped, Object ... msg) throws Exception {
        T t = WebSocketCommonClient.hasCause(parent, wrapped);
        WebSocketCommonClient.assertNotNull(t, msg);
        return t;
    }

    protected static boolean isNullOrEmpty(String val) {
        return val == null || val.trim().equals("");
    }

    private static <T extends Throwable> T hasCause(Throwable parent, Class<? extends Throwable> cause) {
        while (parent != null) {
            if (cause.isInstance(parent)) {
                return (T)parent;
            }
            parent = parent.getCause();
        }
        return null;
    }

    public static String getCauseMessage(Throwable t) {
        String msg = null;
        while (t != null) {
            msg = t.getMessage();
            t = t.getCause();
        }
        return msg;
    }

    public static void logMsg(Object ... msg) {
        logger.log(System.Logger.Level.INFO, WebSocketCommonClient.objectsToString(msg));
    }

    public static void logTrace(Object ... msg) {
        logger.log(System.Logger.Level.TRACE, WebSocketCommonClient.objectsToString(msg));
    }

    protected static String objectsToString(Object ... objects) {
        return WebSocketCommonClient.objectsToStringWithDelimiter(" ", objects);
    }

    protected static String objectsToStringWithDelimiter(String delimiter, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        if (objects != null) {
            for (Object o : objects) {
                if (o != null && o.getClass().isArray() && o.toString().startsWith("[L")) {
                    sb.append(WebSocketCommonClient.objectsToStringWithDelimiter(delimiter, (Object[])o));
                    continue;
                }
                sb.append(o).append(delimiter);
            }
        }
        return sb.toString().trim();
    }

    protected static Map<String, List<String>> basicAuthenticationAsHeaderMap(String userName, String password) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        String toEncode = userName + ':' + password;
        String base64 = new BASE64Encoder().encode(toEncode.getBytes());
        headers.put("Authorization", Arrays.asList("Basic " + base64));
        return headers;
    }

    protected void setupWebSocketContainerBeforeConnect(WebSocketContainer clientContainer) {
    }

    protected void setRequestProtocol(String protocol) {
        this.requestProtocol = protocol;
    }

    protected void setCountDownLatchCount(int countDownLatchCount) {
        this.getTestCase().setCountDownLatchCount(countDownLatchCount);
    }

    protected void setClientEndpoint(Class<? extends ClientEndpoint<?>> endpoint) {
        this.getTestCase().setClientEndpoint(endpoint);
    }

    protected void setClientEndpointInstance(ClientEndpoint<?> endpointInstance) {
        this.getTestCase().setClientEndpointInstance(endpointInstance);
    }

    protected void setAnnotatedClientEndpoint(AnnotatedClientEndpoint<?> annotatedEndpoint) {
        this.getTestCase().setAnnotatedClientEndpoint(annotatedEndpoint);
    }

    protected void addClientConfigurator(ClientEndpointConfig.Configurator configurator) {
        this.getTestCase().addClientConfigurator(configurator);
    }

    protected void setClientEndpointConfig(ClientEndpointConfig clientEndpointConfig) {
        this.getTestCase().setClientEndpointConfig(clientEndpointConfig);
    }

    protected void setClientCallback(EndpointCallback callback) {
        this.getTestCase().setCallback(callback);
    }

    protected void addClientCallback(EndpointCallback callback) {
        this.getTestCase().addClientCallback(callback);
    }

    protected Session getSession() throws Exception {
        Session session = this.getTestCase().getSession();
        WebSocketCommonClient.assertNotNull(session, "Session is null! Has been closed?");
        return session;
    }

    protected String getResponseAsString() {
        return this.getTestCase().getResponseAsString();
    }

    protected <T> T getLastResponse(Class<T> type) {
        return this.getTestCase().getLastResponse(type);
    }

    protected void printClientCall(boolean printClientCall) {
        this.getTestCase().printClientCall(printClientCall);
    }

    protected void logExceptionOnInvocation(boolean log) {
        this.logExceptionOnInvoke = log;
    }

    public static String toString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    protected static enum Property {
        BASIC_AUTH_PASSWD,
        BASIC_AUTH_USER,
        CONTENT,
        EXPECTED_HEADERS,
        IGNORE_STATUS_CODE,
        REQUEST,
        SEARCH_STRING,
        SEARCH_STRING_IGNORE_CASE,
        STATUS_CODE,
        UNEXPECTED_HEADERS,
        UNEXPECTED_RESPONSE_MATCH,
        UNORDERED_SEARCH_STRING;

    }

    public class Entity {
        private Object[] entities;

        public Entity(Object ... partials) {
            this.entities = partials;
        }

        public Entity(Object entity) {
            this(new Object[]{entity});
        }

        public boolean isInstance(Class<?> clazz) {
            return clazz.isInstance(this.entities[0]);
        }

        public int length() {
            return this.entities.length;
        }

        public <T> T getEntityAt(Class<T> clazz, int index) {
            if (ByteBuffer.class.isAssignableFrom(clazz)) {
                return (T)this.cloneByteBuffer(index);
            }
            return (T)this.entities[index];
        }

        public <T> T getEntityAt(int index) {
            if (ByteBuffer.class.isInstance(this.entities[index])) {
                return (T)this.cloneByteBuffer(index);
            }
            return (T)this.entities[index];
        }

        private ByteBuffer clone(ByteBuffer message) {
            byte[] orig = message.array();
            byte[] array = new byte[orig.length];
            System.arraycopy(orig, 0, array, 0, orig.length);
            return ByteBuffer.wrap(array);
        }

        private ByteBuffer cloneByteBuffer(int index) {
            ByteBuffer bb = (ByteBuffer)this.entities[index];
            return this.clone(bb);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.entities.length);
            if (this.entities.length == 1) {
                sb.append(" part: ");
            } else {
                sb.append(" parts: ");
            }
            sb.append(WebSocketCommonClient.objectsToStringWithDelimiter(", ", this.entities));
            return sb.toString();
        }
    }
}

