/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.configurable;

import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Assertable;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.CallableProvider;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.ConfigurableObject;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.Registrar;
import ee.jakarta.tck.ws.rs.api.rs.core.configurable.SingleCheckAssertable;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.FirstFilter;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.SecondFilter;
import ee.jakarta.tck.ws.rs.ee.rs.core.configurable.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -8051302528257391040L;
    private static final int configurableCnt = 2;
    private int registeredClassesCnt = -1;
    private int registeredInstancesCnt = -1;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_configurable_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/configurable/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_configurable_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, Assertable.class, CallableProvider.class, Registrar.class, SingleCheckAssertable.class, ConfigurableObject.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void registerClassWriterContractsTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassWriterContractsTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity<?> entity = JAXRSClientIT.getCallableEntity("registerClassWriterContractsTest");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Class)registerable, new Class[]{MessageBodyWriter.class});
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            Response response = i.invoke();
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            JAXRSClientIT.assertEquals("registerClassWriterContractsTest", responseString, "Expected", "registerClassWriterContractsTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully wrote Callable by provider registered on Configurable", Assertable.getLocation(cnt));
            try {
                Callable callable = (Callable)response.readEntity(Callable.class);
                JAXRSClientIT.fault("MessageBodyReader contract has been unexpectedly registered", callable);
                continue;
            }
            catch (Exception e) {
                JAXRSClientIT.logMsg("MessageBodyReader contract has not been registered as expected", e);
            }
        }
    }

    @Test
    public void registerClassReaderContractsTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassReaderContractsTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerClassReaderContractsTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Class)registerable, new Class[]{MessageBodyReader.class});
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            Response response = i.invoke();
            Callable callable = (Callable)response.readEntity(Callable.class);
            JAXRSClientIT.assertEquals("registerClassReaderContractsTest", callable.toString(), "Expected", "registerClassReaderContractsTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully read Callable by provider registered on Configurable", Assertable.getLocation(cnt));
        }
    }

    @Test
    public void registerClassEmptyContractsTest() throws JAXRSCommonClient.Fault {
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Class)registerable, new Class[0]);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProvider();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, classes, entity);
            JAXRSClientIT.logMsg("The provider of with contracts has ben ignored as expected");
        }
    }

    @Test
    public void registerClassNotAssignableContractsTest() throws JAXRSCommonClient.Fault {
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Class)registerable, new Class[]{ClientRequestFilter.class});
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProvider();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, classes, entity);
            JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
        }
    }

    @Test
    public void registerClassNullContractsTest() throws JAXRSCommonClient.Fault {
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Class)registerable, (Class[])null);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProvider();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, classes, entity);
            JAXRSClientIT.logMsg("The provider with null contract has ben ignored as expected");
        }
    }

    @Test
    public void registerClassBindingPriorityFirstIsSecondTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassBindingPriorityFirstIsSecondTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerClassBindingPriorityFirstIsSecondTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(FirstFilter.class, 400);
                    config.register(SecondFilter.class, 399);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 2);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            String response = (String)i.invoke(String.class);
            JAXRSClientIT.assertEquals(FirstFilter.class.getName(), response, "Unexpected filter ordering, the last was", response);
            JAXRSClientIT.logMsg(response, "has been executed as second, as expected");
        }
    }

    @Test
    public void registerClassBindingPriorityFirstIsFirstTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassBindingPriorityFirstIsFirstTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerClassBindingPriorityFirstIsFirstTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(FirstFilter.class, 300);
                    config.register(SecondFilter.class, 399);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 2);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            String response = (String)i.invoke(String.class);
            JAXRSClientIT.assertEquals(SecondFilter.class.getName(), response, "Unexpected filter ordering, the last was", response);
            JAXRSClientIT.logMsg(response, "has been executed as second, as expected");
        }
    }

    @Test
    public void registerObjectBindingPriorityTest() throws JAXRSCommonClient.Fault {
        String content = "registerObjectBindingPriorityTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerObjectBindingPriorityTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register((Object)new FirstFilter(), 400);
                    config.register((Object)new SecondFilter(), 399);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 2);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            String response = (String)i.invoke(String.class);
            JAXRSClientIT.assertEquals(FirstFilter.class.getName(), response, "Unexpected filter ordering, the last was", response);
            JAXRSClientIT.logMsg(response, "has been executed as second, as expected");
        }
    }

    @Test
    public void registerObjectWriterContractsTest() throws JAXRSCommonClient.Fault {
        String content = "registerObjectWriterContractsTest";
        Object[] instances = this.createProviderInstances();
        Entity<?> entity = JAXRSClientIT.getCallableEntity("registerObjectWriterContractsTest");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(registerable, new Class[]{MessageBodyWriter.class});
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, instances, entity);
            Response response = i.invoke();
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            JAXRSClientIT.assertEquals("registerObjectWriterContractsTest", responseString, "Expected", "registerObjectWriterContractsTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully wrote Callable by provider registered on Configurable", Assertable.getLocation(cnt));
            try {
                Callable callable = (Callable)response.readEntity(Callable.class);
                JAXRSClientIT.fault("MessageBodyReader contract has been unexpectedly registered", callable);
                continue;
            }
            catch (Exception e) {
                JAXRSClientIT.logMsg("MessageBodyReader contract has not been registered as expected", e);
            }
        }
    }

    @Test
    public void registerObjectReaderContractsTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassReaderContractsTest";
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"registerClassReaderContractsTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(registerable, new Class[]{MessageBodyReader.class});
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, instances, entity);
            Response response = i.invoke();
            Callable callable = (Callable)response.readEntity(Callable.class);
            JAXRSClientIT.assertEquals("registerClassReaderContractsTest", callable.toString(), "Expected", "registerClassReaderContractsTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully read Callable by provider registered on Configurable", Assertable.getLocation(cnt));
        }
    }

    @Test
    public void registerObjectEmptyContractsTest() throws JAXRSCommonClient.Fault {
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(registerable, new Class[0]);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProviderInstance();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, instances, entity);
            JAXRSClientIT.logMsg("The provider with empty contracts has ben ignored as expected");
        }
    }

    @Test
    public void registerObjectNotAssignableContractsTest() throws JAXRSCommonClient.Fault {
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(registerable, new Class[]{ClientRequestFilter.class});
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProviderInstance();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, instances, entity);
            JAXRSClientIT.logMsg("The provider withO unassignable contract has ben ignored as expected");
        }
    }

    @Test
    public void registerObjectNullContractsTest() throws JAXRSCommonClient.Fault {
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    config.register(registerable, (Class[])null);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProvider();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, instances, entity);
            JAXRSClientIT.logMsg("The provider with null contract has ben ignored as expected");
        }
    }

    @Test
    public void registerClassWriterContractsInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassWriterContractsInMapTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity<?> entity = JAXRSClientIT.getCallableEntity("registerClassWriterContractsInMapTest");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<MessageBodyWriter>, Integer> contracts = new HashMap<Class<MessageBodyWriter>, Integer>();
                    contracts.put(MessageBodyWriter.class, 100);
                    config.register((Class)registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            Response response = i.invoke();
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            JAXRSClientIT.assertEquals("registerClassWriterContractsInMapTest", responseString, "Expected", "registerClassWriterContractsInMapTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully wrote Callable by provider registered on Configurable", Assertable.getLocation(cnt));
            try {
                Callable callable = (Callable)response.readEntity(Callable.class);
                JAXRSClientIT.fault("MessageBodyReader contract has been unexpectedly registered", callable);
                continue;
            }
            catch (Exception e) {
                JAXRSClientIT.logMsg("MessageBodyReader contract has not been registered as expected", e);
            }
        }
    }

    @Test
    public void registerClassReaderContractsInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassReaderContractsInMapTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerClassReaderContractsInMapTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
                    contracts.put(MessageBodyReader.class, 100);
                    config.register((Class)registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            Response response = i.invoke();
            Callable callable = (Callable)response.readEntity(Callable.class);
            JAXRSClientIT.assertEquals("registerClassReaderContractsInMapTest", callable.toString(), "Expected", "registerClassReaderContractsInMapTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully read Callable by provider registered on Configurable", Assertable.getLocation(cnt));
        }
    }

    @Test
    public void registerClassBindingPriorityInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerClassBindingPriorityInMapTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerClassBindingPriorityInMapTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<ClientRequestFilter>, Integer> contracts = new HashMap<Class<ClientRequestFilter>, Integer>();
                    contracts.put(ClientRequestFilter.class, 400);
                    config.register(FirstFilter.class, contracts);
                    contracts.clear();
                    contracts.put(ClientRequestFilter.class, 300);
                    config.register(SecondFilter.class, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Assertable assertable = this.getAssertableWithRegisteredProviderClassesOnConfigurable(cnt, 2);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            String response = (String)i.invoke(String.class);
            JAXRSClientIT.assertEquals(FirstFilter.class.getName(), response, "Unexpected filter ordering, the last was", response);
            JAXRSClientIT.logMsg(response, "has been executed as second, as expected");
        }
    }

    @Test
    public void registerClassNotAssignableContractsInMapTest() throws JAXRSCommonClient.Fault {
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<ClientRequestFilter>, Integer> contracts = new HashMap<Class<ClientRequestFilter>, Integer>();
                    contracts.put(ClientRequestFilter.class, 400);
                    config.register((Class)registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProviderInstance();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, classes, entity);
            JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
        }
    }

    @Test
    public void registerObjectWriterContractsInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerObjectWriterContractsInMapTest";
        Object[] instances = this.createProviderInstances();
        Entity<?> entity = JAXRSClientIT.getCallableEntity("registerObjectWriterContractsInMapTest");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<MessageBodyWriter>, Integer> contracts = new HashMap<Class<MessageBodyWriter>, Integer>();
                    contracts.put(MessageBodyWriter.class, 100);
                    config.register(registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, instances, entity);
            Response response = i.invoke();
            response.bufferEntity();
            String responseString = (String)response.readEntity(String.class);
            JAXRSClientIT.assertEquals("registerObjectWriterContractsInMapTest", responseString, "Expected", "registerObjectWriterContractsInMapTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully wrote Callable by provider registered on Configurable", Assertable.getLocation(cnt));
            try {
                Callable callable = (Callable)response.readEntity(Callable.class);
                JAXRSClientIT.fault("MessageBodyReader contract has been unexpectedly registered", callable);
                continue;
            }
            catch (Exception e) {
                JAXRSClientIT.logMsg("MessageBodyReader contract has not been registered as expected", e);
            }
        }
    }

    @Test
    public void registerObjectReaderContractsInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerObjectReaderContractsInMapTest";
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"registerObjectReaderContractsInMapTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<MessageBodyReader>, Integer> contracts = new HashMap<Class<MessageBodyReader>, Integer>();
                    contracts.put(MessageBodyReader.class, 100);
                    config.register(registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 1);
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Invocation i = this.checkConfig(registrar, assertable, instances, entity);
            Response response = i.invoke();
            Callable callable = (Callable)response.readEntity(Callable.class);
            JAXRSClientIT.assertEquals("registerObjectReaderContractsInMapTest", callable.toString(), "Expected", "registerObjectReaderContractsInMapTest", "differs from given", response);
            JAXRSClientIT.logMsg("sucessufully read Callable by provider registered on Configurable", Assertable.getLocation(cnt));
        }
    }

    @Test
    public void registerObjectBindingPriorityInMapTest() throws JAXRSCommonClient.Fault {
        String content = "registerObjectBindingPriorityInMapTest";
        Object[] classes = JAXRSClientIT.createProviderClasses();
        Entity entity = Entity.entity((Object)"registerObjectBindingPriorityInMapTest", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<ClientRequestFilter>, Integer> contracts = new HashMap<Class<ClientRequestFilter>, Integer>();
                    contracts.put(ClientRequestFilter.class, 400);
                    config.register((Object)new FirstFilter(), contracts);
                    contracts.clear();
                    contracts.put(ClientRequestFilter.class, 300);
                    config.register((Object)new SecondFilter(), contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            Assertable assertable = this.getAssertableWithRegisteredProviderInstancesOnConfigurable(cnt, 2);
            Invocation i = this.checkConfig(registrar, assertable, classes, entity);
            String response = (String)i.invoke(String.class);
            JAXRSClientIT.assertEquals(FirstFilter.class.getName(), response, "Unexpected filter ordering, the last was", response);
            JAXRSClientIT.logMsg(response, "has been executed as second, as expected");
        }
    }

    @Test
    public void registerObjectNotAssignableContractsInMapTest() throws JAXRSCommonClient.Fault {
        Object[] instances = this.createProviderInstances();
        Entity entity = Entity.entity((Object)"", (String)"*/*");
        IncrementableRegistrar registrar = new IncrementableRegistrar(0, 1){

            @Override
            public void register(Configurable<?> config, Object registerable) {
                if (this.currentValue++ == this.finalValue) {
                    HashMap<Class<ClientRequestFilter>, Integer> contracts = new HashMap<Class<ClientRequestFilter>, Integer>();
                    contracts.put(ClientRequestFilter.class, 400);
                    config.register(registerable, contracts);
                }
            }
        };
        this.setResourceMethod("echo");
        Assertable assertable = this.getAssertableWithNoRegisteredProviderInstance();
        for (int cnt = 0; cnt != 2; ++cnt) {
            JAXRSClientIT.logMsg("Check on Configurable", Assertable.getLocation(cnt));
            registrar.setCurrentValue(0).setFinalValue(cnt);
            this.checkConfig(registrar, assertable, instances, entity);
            JAXRSClientIT.logMsg("The provider with unassignable contract has ben ignored as expected");
        }
    }

    private Assertable getAssertableWithRegisteredProviderClassesOnConfigurable(final int configurableIndex, final int numberOfRegisteredClasses) {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int size = config.getConfiguration().getClasses().size();
                int shouldBe = this.getLocationIndex() >= configurableIndex ? numberOfRegisteredClasses : 0;
                JAXRSCommonClient.assertEqualsInt(size, shouldBe += JAXRSClientIT.this.registeredClassesCnt, "unexpected number of registered classes found:", size, this.getLocation());
                JAXRSCommonClient.logMsg("Found", size, "provider(s) as expected");
            }
        };
        return assertable;
    }

    private Assertable getAssertableWithRegisteredProviderInstancesOnConfigurable(final int configurableIndex, final int numberOfRegisteredInstances) {
        SingleCheckAssertable assertable = new SingleCheckAssertable(){

            @Override
            protected void check(Configurable<?> configurable) throws JAXRSCommonClient.Fault {
                this.assertSizeAndLog(configurable);
            }

            void assertSizeAndLog(Configurable<?> config) throws JAXRSCommonClient.Fault {
                int size = config.getConfiguration().getInstances().size();
                int shouldBe = this.getLocationIndex() >= configurableIndex ? numberOfRegisteredInstances : 0;
                JAXRSCommonClient.assertEqualsInt(size, shouldBe += JAXRSClientIT.this.registeredInstancesCnt, "unexpected number of registered classes found:", size, this.getLocation());
                JAXRSCommonClient.logMsg("Found", size, "provider(s) as expected");
            }
        };
        return assertable;
    }

    private Assertable getAssertableWithNoRegisteredProvider() {
        return this.getAssertableWithRegisteredProviderClassesOnConfigurable(0, 0);
    }

    private Assertable getAssertableWithNoRegisteredProviderInstance() {
        return this.getAssertableWithRegisteredProviderInstancesOnConfigurable(0, 0);
    }

    protected Object[] createProviderInstances() {
        Object[] instances = new CallableProvider[]{new CallableProvider(){}, new CallableProvider(){}};
        return instances;
    }

    protected static Class<?>[] createProviderClasses() {
        Class[] classes = new Class[]{CallableProvider.class, CallableProvider.class};
        return classes;
    }

    protected Invocation checkConfig(Registrar registrar, Assertable assertable, Object[] registerables, Entity<?> entity) throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        Configuration config = client.getConfiguration();
        this.registeredClassesCnt = config.getClasses().size();
        this.registeredInstancesCnt = config.getInstances().size();
        JAXRSClientIT.logMsg("Already registered", this.registeredClassesCnt, "classes");
        JAXRSClientIT.logMsg("Already registered", this.registeredInstancesCnt, "instances");
        this.register(registrar, (Configurable<?>)client, registerables[0]);
        assertable.check1OnClient(client);
        assertable.incrementLocation();
        WebTarget target = client.target(this.getAbsoluteUrl());
        this.register(registrar, (Configurable<?>)target, registerables[1]);
        assertable.check2OnTarget(target);
        assertable.incrementLocation();
        Invocation.Builder builder = target.request();
        Invocation invocation = builder.buildPost(entity);
        return invocation;
    }

    protected void register(Registrar registrar, Configurable<?> config, Object registerable) {
        registrar.register(config, registerable);
    }

    private void setResourceMethod(String method) {
        this.setContextRoot(this.getContextRoot() + "/" + method);
    }

    private static Entity<?> getCallableEntity(String content) {
        Entity entity = Entity.entity(CallableProvider.createCallable(content), (MediaType)MediaType.WILDCARD_TYPE);
        return entity;
    }

    protected class IncrementableRegistrar
    extends Registrar {
        int currentValue;
        int finalValue;

        int getFinalValue() {
            return this.finalValue;
        }

        IncrementableRegistrar setFinalValue(int finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        IncrementableRegistrar(int initValue, int finalValue) {
            this.currentValue = initValue;
            this.finalValue = finalValue;
        }

        int getCurrentValue() {
            return this.currentValue;
        }

        IncrementableRegistrar setCurrentValue(int set) {
            this.currentValue = set;
            return this;
        }
    }
}

