/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Values;

import com.shapesecurity.salvation2.Utils;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Nonce {
    @Nonnull
    public final String base64ValuePart;

    private Nonce(@Nonnull String base64Valuepart) {
        this.base64ValuePart = base64Valuepart;
    }

    public static Optional<Nonce> parseNonce(String value) {
        String nonce;
        String lowcaseValue = value.toLowerCase(Locale.ENGLISH);
        if (lowcaseValue.startsWith("'nonce-") && lowcaseValue.endsWith("'") && Utils.IS_BASE64_VALUE.test(nonce = value.substring(7, value.length() - 1))) {
            return Optional.of(new Nonce(nonce));
        }
        return Optional.empty();
    }

    public String toString() {
        return "'nonce-" + this.base64ValuePart + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nonce nonce = (Nonce)o;
        return this.base64ValuePart.equals(nonce.base64ValuePart);
    }

    public int hashCode() {
        return Objects.hash(this.base64ValuePart);
    }
}

