/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeSet
implements NodeList,
Cloneable {
    protected transient int m_next = 0;
    protected final transient boolean m_mutable = true;
    protected final transient boolean m_cacheNodes = true;
    private final int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeSet(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = 0;
    }

    private void runTo(int index) {
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    @Override
    public Node item(int index) {
        this.runTo(index);
        if (null == this.m_map) {
            return null;
        }
        return this.m_map[index];
    }

    @Override
    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(Node n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)super.clone();
        if (null != this.m_map && this.m_map == clone.m_map) {
            clone.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public int size() {
        return this.m_firstFree;
    }
}

