/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Symbol;

public final class ClassConfiguration {
    private Map<String, PropertyInfo> propertyMap_;
    private Map<Symbol, Method> symbolMap_;
    private Map<String, Method> functionMap_;
    private Map<String, PropertyInfo> staticPropertyMap_;
    private Map<String, Method> staticFunctionMap_;
    private List<ConstantInfo> constants_;
    private final String extendedClassName_;
    private final Class<? extends HtmlUnitScriptable> hostClass_;
    private final String hostClassSimpleName_;
    private Member jsConstructor_;
    private final Class<?>[] domClasses_;
    private final boolean jsObject_;
    private final String className_;

    public ClassConfiguration(Class<? extends HtmlUnitScriptable> hostClass, Class<?>[] domClasses, boolean jsObject, String className, String extendedClassName) {
        this.hostClass_ = hostClass;
        this.hostClassSimpleName_ = this.hostClass_.getSimpleName();
        this.jsObject_ = jsObject;
        this.domClasses_ = domClasses;
        this.className_ = className == null ? this.getHostClass().getSimpleName() : className;
        this.extendedClassName_ = extendedClassName;
    }

    void setJSConstructor(Member jsConstructor) {
        if (this.jsConstructor_ != null) {
            throw new IllegalStateException("Can not have two constructors for " + this.jsConstructor_.getDeclaringClass().getName());
        }
        this.jsConstructor_ = jsConstructor;
    }

    public void addProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        if (this.propertyMap_ == null) {
            this.propertyMap_ = new HashMap<String, PropertyInfo>();
        }
        this.propertyMap_.put(name, info);
    }

    public void addStaticProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        if (this.staticPropertyMap_ == null) {
            this.staticPropertyMap_ = new HashMap<String, PropertyInfo>();
        }
        this.staticPropertyMap_.put(name, info);
    }

    public void addConstant(String name, Object value) {
        if (this.constants_ == null) {
            this.constants_ = new ArrayList<ConstantInfo>();
        }
        int flag = 5;
        if (this.getClassName().endsWith("Array")) {
            flag |= 2;
        }
        this.constants_.add(new ConstantInfo(name, value, flag));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, PropertyInfo> getPropertyMap() {
        return this.propertyMap_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<Symbol, Method> getSymbolMap() {
        return this.symbolMap_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, PropertyInfo> getStaticPropertyMap() {
        return this.staticPropertyMap_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, Method> getFunctionMap() {
        return this.functionMap_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, Method> getStaticFunctionMap() {
        return this.staticFunctionMap_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public List<ConstantInfo> getConstants() {
        return this.constants_;
    }

    public void addSymbol(Symbol symbol, Method method) {
        if (this.symbolMap_ == null) {
            this.symbolMap_ = new HashMap<Symbol, Method>();
        }
        this.symbolMap_.put(symbol, method);
    }

    public void addFunction(String name, Method method) {
        if (this.functionMap_ == null) {
            this.functionMap_ = new HashMap<String, Method>();
        }
        this.functionMap_.put(name, method);
    }

    public void addStaticFunction(String name, Method method) {
        if (this.staticFunctionMap_ == null) {
            this.staticFunctionMap_ = new HashMap<String, Method>();
        }
        this.staticFunctionMap_.put(name, method);
    }

    public String getExtendedClassName() {
        return this.extendedClassName_;
    }

    public Class<? extends HtmlUnitScriptable> getHostClass() {
        return this.hostClass_;
    }

    public String getHostClassSimpleName() {
        return this.hostClassSimpleName_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Member getJsConstructor() {
        return this.jsConstructor_;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Class<?>[] getDomClasses() {
        return this.domClasses_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    public String getClassName() {
        return this.className_;
    }

    public static class ConstantInfo {
        private final String name_;
        private final Object value_;
        private final int flag_;

        public ConstantInfo(String name, Object value, int flag) {
            this.name_ = name;
            this.value_ = value;
            this.flag_ = flag;
        }

        public String getName() {
            return this.name_;
        }

        public Object getValue() {
            return this.value_;
        }

        public int getFlag() {
            return this.flag_;
        }
    }

    public static class PropertyInfo {
        private final Method readMethod_;
        private final Method writeMethod_;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public PropertyInfo(Method readMethod, Method writeMethod) {
            this.readMethod_ = readMethod;
            this.writeMethod_ = writeMethod;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Method getReadMethod() {
            return this.readMethod_;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Method getWriteMethod() {
            return this.writeMethod_;
        }
    }
}

