/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.AbstractDomNodeList;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeIterator;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.DomTreeWalker;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;

public abstract class SgmlPage
extends DomNode
implements Page,
Document,
DocumentTraversal {
    private DocumentType documentType_;
    private final WebResponse webResponse_;
    private WebWindow enclosingWindow_;
    private final WebClient webClient_;
    private boolean printing_;

    public SgmlPage(WebResponse webResponse, WebWindow webWindow) {
        super(null);
        this.webResponse_ = webResponse;
        this.enclosingWindow_ = webWindow;
        this.webClient_ = webWindow.getWebClient();
    }

    @Override
    public void cleanUp() {
        if (this.getWebClient().getCache().getCachedResponse(this.webResponse_.getWebRequest()) == null) {
            this.webResponse_.cleanUp();
        }
    }

    @Override
    public WebResponse getWebResponse() {
        return this.webResponse_;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public WebWindow getEnclosingWindow() {
        return this.enclosingWindow_;
    }

    public void setEnclosingWindow(WebWindow window) {
        this.enclosingWindow_ = window;
    }

    public WebClient getWebClient() {
        return this.webClient_;
    }

    @Override
    public DomDocumentFragment createDocumentFragment() {
        return new DomDocumentFragment(this);
    }

    @Override
    public final DocumentType getDoctype() {
        return this.documentType_;
    }

    protected void setDocumentType(DocumentType type) {
        this.documentType_ = type;
    }

    @Override
    public SgmlPage getPage() {
        return this;
    }

    public abstract Charset getCharset();

    @Override
    public DomElement getDocumentElement() {
        DomNode childNode;
        for (childNode = this.getFirstChild(); childNode != null && !(childNode instanceof DomElement); childNode = childNode.getNextSibling()) {
        }
        return (DomElement)childNode;
    }

    protected SgmlPage clone() {
        try {
            return (SgmlPage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    @Override
    public String asXml() {
        DomElement documentElement = this.getDocumentElement();
        if (documentElement == null) {
            return "";
        }
        return documentElement.asXml();
    }

    public abstract boolean hasCaseSensitiveTagNames();

    @Override
    public void normalizeDocument() {
        this.getDocumentElement().normalize();
    }

    @Override
    public String getCanonicalXPath() {
        return "/";
    }

    @Override
    public DomAttr createAttribute(String name) {
        return new DomAttr(this.getPage(), null, name, "", false);
    }

    @Override
    public URL getUrl() {
        WebResponse wr = this.getWebResponse();
        if (null == wr) {
            return UrlUtils.URL_ABOUT_BLANK;
        }
        return this.getWebResponse().getWebRequest().getUrl();
    }

    @Override
    public boolean isHtmlPage() {
        return false;
    }

    @Override
    public DomNodeList<DomElement> getElementsByTagName(final String tagName) {
        return new AbstractDomNodeList<DomElement>((DomNode)this){

            @Override
            protected List<DomElement> provideElements() {
                ArrayList<DomElement> res = new ArrayList<DomElement>();
                boolean caseSensitive = SgmlPage.this.hasCaseSensitiveTagNames();
                for (DomElement elem : SgmlPage.this.getDomElementDescendants()) {
                    String localName = elem.getLocalName();
                    if (!"*".equals(tagName) && !localName.equals(tagName) && (caseSensitive || !localName.equalsIgnoreCase(tagName))) continue;
                    res.add(elem);
                }
                return res;
            }
        };
    }

    @Override
    public DomNodeList<DomElement> getElementsByTagNameNS(final String namespaceURI, String localName) {
        return new AbstractDomNodeList<DomElement>((DomNode)this){

            @Override
            protected List<DomElement> provideElements() {
                ArrayList<DomElement> res = new ArrayList<DomElement>();
                Comparator<String> comparator = SgmlPage.this.hasCaseSensitiveTagNames() ? Comparator.nullsFirst(String::compareTo) : Comparator.nullsFirst(String::compareToIgnoreCase);
                for (DomElement elem : SgmlPage.this.getDomElementDescendants()) {
                    String locName = elem.getLocalName();
                    if (!"*".equals(namespaceURI) && comparator.compare(namespaceURI, elem.getNamespaceURI()) != 0 || !"*".equals(locName) && comparator.compare(locName, elem.getLocalName()) != 0) continue;
                    res.add(elem);
                }
                return res;
            }
        };
    }

    @Override
    public CDATASection createCDATASection(String data) {
        return new DomCDataSection(this, data);
    }

    @Override
    public Text createTextNode(String data) {
        return new DomText(this, data);
    }

    @Override
    public Comment createComment(String data) {
        return new DomComment(this, data);
    }

    @Override
    @Deprecated
    public DomTreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return new DomTreeWalker((DomNode)root, whatToShow, filter, entityReferenceExpansion);
    }

    @Override
    public DomNodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return new DomNodeIterator((DomNode)root, whatToShow, filter, entityReferenceExpansion);
    }

    public abstract String getContentType();

    public void clearComputedStyles() {
    }

    public void clearComputedStyles(DomElement element) {
    }

    public void clearComputedStylesUpToRoot(DomElement element) {
    }

    public boolean isPrinting() {
        return this.printing_;
    }

    public void setPrinting(boolean printing) {
        this.printing_ = printing;
        this.clearComputedStyles();
    }
}

