/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.application.app;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import jakarta.mvc.tck.tests.application.app.MvcAppWebXmlApplication;
import jakarta.mvc.tck.tests.application.app.MvcAppWebXmlController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="2.0")
public class MvcAppWebXmlTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebAppDescriptor descriptor = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).addDefaultNamespaces()).version("5.0").createServlet().servletName(MvcAppWebXmlApplication.class.getName()).up()).createServletMapping().servletName(MvcAppWebXmlApplication.class.getName()).urlPattern(new String[]{"/web-xml-app-path/*"}).up();
        return Archives.getMvcArchive(MvcAppWebXmlApplication.class).withWebXml(descriptor).addClass(MvcAppWebXmlController.class).addView("1 + 2 = ${1+2}", "view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_applications", id="application-class"), @SpecAssertion(section="mvc_applications", id="url-space")})
    public void testUrlSpaceViaAnnotation() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "web-xml-app-path/application/app/web-xml");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"1 + 2 = 3"));
    }
}

