/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;

class MatrixTransformer {
    private static final AffineTransform FLIP_X_TRANSFORM = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static final AffineTransform FLIP_Y_TRANSFORM = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);

    MatrixTransformer() {
    }

    public SvgMatrix flipX(SvgMatrix svgMatrix) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(FLIP_X_TRANSFORM);
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix flipY(SvgMatrix svgMatrix) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(FLIP_Y_TRANSFORM);
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix inverse(SvgMatrix svgMatrix) {
        try {
            AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
            tr = tr.createInverse();
            return MatrixTransformer.toSvgMatrix(tr);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Failed to execute 'inverse' on 'SVGMatrix': The matrix is not invertible.");
        }
    }

    public SvgMatrix multiply(SvgMatrix factor1, SvgMatrix factor2) {
        AffineTransform f1 = MatrixTransformer.toAffineTransform(factor1);
        AffineTransform f2 = MatrixTransformer.toAffineTransform(factor2);
        f1.concatenate(f2);
        return MatrixTransformer.toSvgMatrix(f1);
    }

    public SvgMatrix rotate(SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.rotate(Math.toRadians(angle));
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix rotateFromVector(SvgMatrix svgMatrix, double x, double y) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.rotate(Math.atan2(y, x));
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix scale(SvgMatrix svgMatrix, double factor) {
        return this.scaleNonUniform(svgMatrix, factor, factor);
    }

    public SvgMatrix scaleNonUniform(SvgMatrix svgMatrix, double factorX, double factorY) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.scale(factorX, factorY);
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix skewX(SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(angle)), 0.0));
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix skewY(SvgMatrix svgMatrix, double angle) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(angle))));
        return MatrixTransformer.toSvgMatrix(tr);
    }

    public SvgMatrix translate(SvgMatrix svgMatrix, double x, double y) {
        AffineTransform tr = MatrixTransformer.toAffineTransform(svgMatrix);
        tr.translate(x, y);
        return MatrixTransformer.toSvgMatrix(tr);
    }

    private static AffineTransform toAffineTransform(SvgMatrix svgMatrix) {
        return new AffineTransform(svgMatrix.getScaleX(), svgMatrix.getShearY(), svgMatrix.getShearX(), svgMatrix.getScaleY(), svgMatrix.getTranslateX(), svgMatrix.getTranslateY());
    }

    private static SvgMatrix toSvgMatrix(AffineTransform affineTransform) {
        return new SvgMatrix(affineTransform.getShearX(), affineTransform.getShearY(), affineTransform.getScaleX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
    }

    static final class SvgMatrix
    implements Serializable {
        private double shearX_;
        private double shearY_;
        private double scaleX_;
        private double scaleY_;
        private double translateX_;
        private double translateY_;

        SvgMatrix() {
            this(0.0, 0.0, 1.0, 1.0, 0.0, 0.0);
        }

        SvgMatrix(double shearX, double shearY, double scaleX, double scaleY, double translateX, double translateY) {
            this.shearX_ = shearX;
            this.shearY_ = shearY;
            this.scaleX_ = scaleX;
            this.scaleY_ = scaleY;
            this.translateX_ = translateX;
            this.translateY_ = translateY;
        }

        public double getShearX() {
            return this.shearX_;
        }

        public void setShearX(double shearX) {
            this.shearX_ = shearX;
        }

        public double getShearY() {
            return this.shearY_;
        }

        public void setShearY(double shearY) {
            this.shearY_ = shearY;
        }

        public double getScaleX() {
            return this.scaleX_;
        }

        public void setScaleX(double scaleX) {
            this.scaleX_ = scaleX;
        }

        public double getScaleY() {
            return this.scaleY_;
        }

        public void setScaleY(double scaleY) {
            this.scaleY_ = scaleY;
        }

        public double getTranslateX() {
            return this.translateX_;
        }

        public void setTranslateX(double translateX) {
            this.translateX_ = translateX;
        }

        public double getTranslateY() {
            return this.translateY_;
        }

        public void setTranslateY(double translateY) {
            this.translateY_ = translateY;
        }
    }
}

