/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.jbosscommon51;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.javaee5.EnvEntryTypeValuesType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EnvEntryType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.InjectionTargetType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.InjectionTargetTypeImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvEntryTypeImpl<T>
implements Child<T>,
EnvEntryType<T> {
    private T t;
    private Node childNode;

    public EnvEntryTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public EnvEntryTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public EnvEntryType<T> jndiName(String jndiName) {
        this.childNode.getOrCreate("jndi-name").text(jndiName);
        return this;
    }

    public String getJndiName() {
        return this.childNode.getTextValueForPatternName("jndi-name");
    }

    public EnvEntryType<T> removeJndiName() {
        this.childNode.removeChildren("jndi-name");
        return this;
    }

    public EnvEntryType<T> mappedName(String mappedName) {
        this.childNode.getOrCreate("mapped-name").text(mappedName);
        return this;
    }

    public String getMappedName() {
        return this.childNode.getTextValueForPatternName("mapped-name");
    }

    public EnvEntryType<T> removeMappedName() {
        this.childNode.removeChildren("mapped-name");
        return this;
    }

    public InjectionTargetType<EnvEntryType<T>> getOrCreateInjectionTarget() {
        List nodeList = this.childNode.get("injection-target");
        if (nodeList != null && nodeList.size() > 0) {
            return new InjectionTargetTypeImpl<EnvEntryType<T>>(this, "injection-target", this.childNode, (Node)nodeList.get(0));
        }
        return this.createInjectionTarget();
    }

    public InjectionTargetType<EnvEntryType<T>> createInjectionTarget() {
        return new InjectionTargetTypeImpl<EnvEntryType<T>>(this, "injection-target", this.childNode);
    }

    public List<InjectionTargetType<EnvEntryType<T>>> getAllInjectionTarget() {
        ArrayList<InjectionTargetType<EnvEntryType<T>>> list = new ArrayList<InjectionTargetType<EnvEntryType<T>>>();
        List nodeList = this.childNode.get("injection-target");
        for (Node node : nodeList) {
            InjectionTargetTypeImpl<EnvEntryTypeImpl> type = new InjectionTargetTypeImpl<EnvEntryTypeImpl>(this, "injection-target", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public EnvEntryType<T> removeAllInjectionTarget() {
        this.childNode.removeChildren("injection-target");
        return this;
    }

    public EnvEntryType<T> ignoreDependency() {
        this.childNode.getOrCreate("ignore-dependency");
        return this;
    }

    public Boolean isIgnoreDependency() {
        return this.childNode.getSingle("ignore-dependency") != null;
    }

    public EnvEntryType<T> removeIgnoreDependency() {
        this.childNode.removeChild("ignore-dependency");
        return this;
    }

    public EnvEntryType<T> description(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("description").text(name);
            }
        }
        return this;
    }

    public List<String> getAllDescription() {
        ArrayList<String> result = new ArrayList<String>();
        List nodes = this.childNode.get("description");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    public EnvEntryType<T> removeAllDescription() {
        this.childNode.removeChildren("description");
        return this;
    }

    public EnvEntryType<T> envEntryName(String envEntryName) {
        this.childNode.getOrCreate("env-entry-name").text(envEntryName);
        return this;
    }

    public String getEnvEntryName() {
        return this.childNode.getTextValueForPatternName("env-entry-name");
    }

    public EnvEntryType<T> removeEnvEntryName() {
        this.childNode.removeChildren("env-entry-name");
        return this;
    }

    public EnvEntryType<T> envEntryType(EnvEntryTypeValuesType envEntryType) {
        this.childNode.getOrCreate("env-entry-type").text((Object)envEntryType);
        return this;
    }

    public EnvEntryType<T> envEntryType(String envEntryType) {
        this.childNode.getOrCreate("env-entry-type").text(envEntryType);
        return this;
    }

    public EnvEntryTypeValuesType getEnvEntryType() {
        return EnvEntryTypeValuesType.getFromStringValue((String)this.childNode.getTextValueForPatternName("env-entry-type"));
    }

    public String getEnvEntryTypeAsString() {
        return this.childNode.getTextValueForPatternName("env-entry-type");
    }

    public EnvEntryType<T> removeEnvEntryType() {
        this.childNode.removeAttribute("env-entry-type");
        return this;
    }

    public EnvEntryType<T> envEntryValue(String envEntryValue) {
        this.childNode.getOrCreate("env-entry-value").text(envEntryValue);
        return this;
    }

    public String getEnvEntryValue() {
        return this.childNode.getTextValueForPatternName("env-entry-value");
    }

    public EnvEntryType<T> removeEnvEntryValue() {
        this.childNode.removeChildren("env-entry-value");
        return this;
    }

    public EnvEntryType<T> id(String id) {
        this.childNode.attribute("id", id);
        return this;
    }

    public String getId() {
        return this.childNode.getAttribute("id");
    }

    public EnvEntryType<T> removeId() {
        this.childNode.removeAttribute("id");
        return this;
    }
}

