/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.impl.client.deployment.ValidationException;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.container.test.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.container.test.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.protocol.Protocol;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.container.ClassContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentGenerator {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ClassScoped
    private InstanceProducer<DeploymentScenario> deployment;
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<ProtocolRegistry> protocolRegistry;

    public void generateDeployment(@Observes GenerateDeployment event) {
        DeploymentScenarioGenerator generator = (DeploymentScenarioGenerator)((ServiceLoader)this.serviceLoader.get()).onlyOne(DeploymentScenarioGenerator.class, AnnotationDeploymentScenarioGenerator.class);
        DeploymentScenario scenario = new DeploymentScenario();
        for (DeploymentDescription deployment : generator.generate(event.getTestClass())) {
            scenario.addDeployment(deployment);
        }
        this.validate(scenario);
        this.createTestableDeployments(scenario, event.getTestClass());
        this.deployment.set((Object)scenario);
    }

    protected void validate(DeploymentScenario scenario) {
        Container container;
        ContainerRegistry conReg = (ContainerRegistry)this.containerRegistry.get();
        for (TargetDescription target : scenario.targets()) {
            container = conReg.getContainer(target);
            if (container != null) continue;
            this.throwTargetNotFoundValidationException(conReg, target);
        }
        for (org.jboss.arquillian.container.spi.client.deployment.Deployment deployment : scenario.deployments()) {
            container = conReg.getContainer(deployment.getDescription().getTarget());
            if (!"custom".equalsIgnoreCase(container.getContainerConfiguration().getMode()) || !deployment.getDescription().managed()) continue;
            throw new ValidationException("Deployment " + deployment.getDescription().getName() + " is targeted against container " + container.getName() + ". This container is set to mode custom which can not handle managed deployments. " + "Please verify the @" + TargetsContainer.class.getName() + " annotation or container@mode in arquillian.xml");
        }
        ProtocolRegistry proReg = (ProtocolRegistry)this.protocolRegistry.get();
        for (ProtocolDescription proDesc : scenario.protocols()) {
            ProtocolDefinition protocol;
            if (ProtocolDescription.DEFAULT.equals((Object)proDesc) || (protocol = proReg.getProtocol(proDesc)) != null) continue;
            throw new ValidationException(DeploymentScenario.class.getSimpleName() + " contains protocols not maching any defined Protocol in the registry. " + proDesc.getName());
        }
    }

    private void createTestableDeployments(DeploymentScenario scenario, TestClass testCase) {
        ProtocolRegistry protoReg = (ProtocolRegistry)this.protocolRegistry.get();
        this.buildTestableDeployments(scenario, testCase, protoReg);
    }

    private void buildTestableDeployments(DeploymentScenario scenario, TestClass testCase, ProtocolRegistry protoReg) {
        for (org.jboss.arquillian.container.spi.client.deployment.Deployment deployment : scenario.deployments()) {
            DeploymentDescription description = deployment.getDescription();
            if (!description.testable() || !description.isArchiveDeployment()) continue;
            List<Archive<?>> auxiliaryArchives = this.loadAuxiliaryArchives(description);
            ProtocolDefinition protocolDefinition = protoReg.getProtocol(description.getProtocol());
            if (protocolDefinition == null) {
                protocolDefinition = protoReg.getProtocol(((ContainerRegistry)this.containerRegistry.get()).getContainer(description.getTarget()).getDeployableContainer().getDefaultProtocol());
            }
            Protocol<?> protocol = protocolDefinition.getProtocol();
            DeploymentPackager packager = protocol.getPackager();
            Archive applicationArchive = description.getArchive();
            this.applyApplicationProcessors(description.getArchive(), testCase);
            this.applyAuxiliaryProcessors(auxiliaryArchives);
            try {
                if (ClassContainer.class.isInstance(applicationArchive)) {
                    ClassContainer classContainer = (ClassContainer)ClassContainer.class.cast(applicationArchive);
                    classContainer.addClass(testCase.getJavaClass());
                }
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            description.setTestableArchive(packager.generateDeployment(new TestDeployment(deployment.getDescription(), applicationArchive, auxiliaryArchives), ((ServiceLoader)this.serviceLoader.get()).all(ProtocolArchiveProcessor.class)));
        }
    }

    private List<Archive<?>> loadAuxiliaryArchives(DeploymentDescription deployment) {
        ArrayList archives = new ArrayList();
        Collection archiveAppenders = ((ServiceLoader)this.serviceLoader.get()).all(AuxiliaryArchiveAppender.class);
        for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
            Archive auxiliaryArchive = archiveAppender.createAuxiliaryArchive();
            if (auxiliaryArchive == null) continue;
            archives.add(auxiliaryArchive);
        }
        return archives;
    }

    private void applyApplicationProcessors(Archive<?> applicationArchive, TestClass testClass) {
        Collection processors = ((ServiceLoader)this.serviceLoader.get()).all(ApplicationArchiveProcessor.class);
        for (ApplicationArchiveProcessor processor : processors) {
            processor.process(applicationArchive, testClass);
        }
    }

    private void applyAuxiliaryProcessors(List<Archive<?>> auxiliaryArchives) {
        Collection processors = ((ServiceLoader)this.serviceLoader.get()).all(AuxiliaryArchiveProcessor.class);
        for (AuxiliaryArchiveProcessor processor : processors) {
            for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
                processor.process(auxiliaryArchive);
            }
        }
    }

    private void throwTargetNotFoundValidationException(ContainerRegistry conReg, TargetDescription target) {
        if (conReg.getContainers().size() == 0) {
            this.throwNoContainerFound(target);
        }
        this.throwNoMatchFound(conReg, target);
    }

    private void throwNoContainerFound(TargetDescription target) {
        throw new ValidationException("DeploymentScenario contains a target (" + target.getName() + ") not matching any defined Container in the registry.\n" + "Please include at least 1 Deployable Container on your Classpath.");
    }

    private void throwNoMatchFound(ContainerRegistry conReg, TargetDescription target) {
        throw new ValidationException("DeploymentScenario contains a target (" + target.getName() + ") not matching any defined Container in the registry.\n" + "Possible causes are: None of the " + conReg.getContainers().size() + " Containers are marked as default or you have defined a " + "@" + Deployment.class.getSimpleName() + " with a @" + TargetsContainer.class.getSimpleName() + " of value (" + target.getName() + ") that " + "does not match any found/configured Containers (" + this.toString(conReg) + "), see arquillian.xml container@qualifier");
    }

    private String toString(ContainerRegistry reg) {
        StringBuilder sb = new StringBuilder();
        for (Container container : reg.getContainers()) {
            sb.append(container.getName()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

