/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.util;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.facesconfig22.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;

public class WebArchiveBuilder {
    private WebArchive archive;

    public WebArchiveBuilder() {
        this((WebArchive)ShrinkWrap.create(WebArchive.class));
    }

    public WebArchiveBuilder(WebArchive archive) {
        this.archive = archive;
    }

    public WebArchiveBuilder addClass(Class<?> clazz) {
        this.archive.addClass(clazz);
        return this;
    }

    public WebArchiveBuilder addClasses(Class<?> ... classes) {
        this.archive.addClasses((Class[])classes);
        return this;
    }

    public WebArchiveBuilder addView(Asset asset, String name) {
        this.archive.addAsWebInfResource(asset, "views/" + name);
        return this;
    }

    public WebArchiveBuilder addView(String value, String name) {
        return this.addView((Asset)new StringAsset(value), name);
    }

    public WebArchiveBuilder addView(String path) {
        return this.addView((Asset)new ClassLoaderAsset("views/" + path), path);
    }

    public WebArchiveBuilder addBeansXml(String discoveryMode) {
        return this.addBeansXml(((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).addDefaultNamespaces()).beanDiscoveryMode(discoveryMode));
    }

    public WebArchiveBuilder addBeansXml(BeansDescriptor descriptor) {
        this.archive.addAsWebInfResource((Asset)new StringAsset(descriptor.exportAsString()), "beans.xml");
        return this;
    }

    public WebArchiveBuilder withDefaultFaceConfig() {
        WebFacesConfigDescriptor descriptor = ((WebFacesConfigDescriptor)((WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class)).addDefaultNamespaces()).version("2.2");
        this.archive.addAsWebInfResource((Asset)new StringAsset(descriptor.exportAsString()), "faces-config.xml");
        return this;
    }

    public WebArchiveBuilder withDefaultWebXml() {
        WebAppDescriptor descriptor = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).addDefaultNamespaces()).version("3.1").createServlet().servletName("FacesServlet").servletClass("javax.faces.webapp.FacesServlet").up()).createServletMapping().servletName("FacesServlet").urlPattern(new String[]{"*.xhtml"}).up();
        return this.withWebXml(descriptor);
    }

    public WebArchiveBuilder withWebXml(WebAppDescriptor descriptor) {
        this.archive.addAsWebInfResource((Asset)new StringAsset(descriptor.exportAsString()), "web.xml");
        return this;
    }

    public WebArchive build() {
        return this.archive;
    }
}

