/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.viewengine.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mvc.engine.ViewEngine;
import javax.mvc.engine.ViewEngineContext;
import javax.mvc.engine.ViewEngineException;
import javax.servlet.ServletContext;

@ApplicationScoped
public class CustomViewEngine
implements ViewEngine {
    @Inject
    private ServletContext servletContext;

    public boolean supports(String view) {
        return view.endsWith(".custom");
    }

    public void processView(ViewEngineContext context) throws ViewEngineException {
        try {
            String result = this.loadTemplateByName(context.getView());
            for (String key : context.getModels()) {
                result = result.replace("%" + key + "%", Objects.toString(context.getModels().get(key)));
            }
            context.getResponseHeaders().putSingle((Object)"Content-Type", (Object)"text/html; charset=UTF-8");
            context.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ViewEngineException("Failed to render view", (Throwable)e);
        }
    }

    private String loadTemplateByName(String view) throws IOException {
        int length;
        String viewPath = "/WEB-INF/views/" + view;
        InputStream inputStream = this.servletContext.getResourceAsStream(viewPath);
        if (inputStream == null) {
            throw new IOException("Cannot find view: " + viewPath);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return new String(result.toByteArray(), StandardCharsets.UTF_8);
    }
}

