/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.security.csrf.verify;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;

abstract class AbstractCsrfVerifyTest {
    private WebClient webClient;
    @ArquillianResource
    private URL baseUrl;

    AbstractCsrfVerifyTest() {
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    Page submitForm(String formType, boolean submitValidToken, String name) throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/verify/form");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        String nameInputId = "input-" + formType;
        DomElement nameInputElement = formPage.getElementById(nameInputId);
        Assert.assertNotNull((String)"Name input element not found", (Object)nameInputElement);
        nameInputElement.setAttribute("value", name);
        if (!submitValidToken) {
            String tokenInputId = "token-" + formType;
            DomElement tokenInputElement = formPage.getElementById(tokenInputId);
            Assert.assertNotNull((String)"Token input element not found", (Object)tokenInputElement);
            tokenInputElement.setAttribute("value", "INVALID-TOKEN");
        }
        String submitButtonId = "submit-" + formType;
        DomElement submitButton = formPage.getElementById(submitButtonId);
        Assert.assertNotNull((String)"Submit button not found", (Object)submitButton);
        return submitButton.click();
    }
}

