/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.mvc.uri;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.mvc.uri.UriBuildingController;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class UriBuildingTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(UriBuildingController.class).addView("<html><span id='simple'>${mvc.uri('UriBuildingController#simple')}</span><span id='path-param'>${mvc.uri('UriBuildingController#pathParam', {'value': 'foo'})}</span><span id='query-param'>${mvc.uri('UriBuildingController#queryParam', {'value': 'bar'})}</span><span id='matrix-param'>${mvc.uri('UriBuildingController#matrixParam', {'value': 'foobar'})}</span><span id='path-encoding'>${mvc.uri('UriBuildingController#pathParam', {'value': 'foo bar'})}</span><span id='query-encoding'>${mvc.uri('UriBuildingController#queryParam', {'value': 'foo bar'})}</span><span id='matrix-encoding'>${mvc.uri('UriBuildingController#matrixParam', {'value': 'foo bar'})}</span><span id='uri-ref'>${mvc.uri('ref-id')}</span></html>", "links.jsp").addView("Rendered view", "view.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_uri", id="el-access"), @SpecAssertion(section="mvc_uri", id="class-method-name")})
    public void simpleUriViaEl() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("simple").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/simple"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="param-map")
    public void mapPathParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("path-param").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/path/foo"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="param-map")
    public void mapQueryParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("query-param").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/query?value=bar"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="param-map")
    public void mapMatrixParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("matrix-param").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/matrix;value=foobar"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="uri-encoding")
    public void encodingPathParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("path-encoding").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/path/foo%20bar"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="uri-encoding")
    public void encodingQueryParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("query-encoding").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/query?value=foo+bar"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="uri-encoding")
    public void encodingMatrixParam() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("matrix-encoding").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/param/matrix;value=foo%20bar"));
    }

    @Test
    @SpecAssertion(section="mvc_uri", id="uri-ref")
    public void supportsUriRef() throws IOException {
        HtmlPage page = (HtmlPage)new WebClient().getPage(this.baseUrl.toString() + "mvc/uri/links");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getElementById("uri-ref").getTextContent(), (Matcher)CoreMatchers.endsWith((String)"/mvc/uri/uriref"));
    }
}

