/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.i18n.access;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.i18n.access.I18nAccessController;
import org.mvcspec.tck.tests.i18n.access.I18nAccessLocaleResolver;
import org.mvcspec.tck.tests.i18n.access.I18nAccessViewEngine;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class I18nAccessTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(I18nAccessController.class).addClass(I18nAccessLocaleResolver.class).addClass(I18nAccessViewEngine.class).addView("i18n/access/view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_introduction", id="mvc-context-locale")})
    public void accessLocaleFromController() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/access").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Controller = [fr]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_introduction", id="mvc-context-locale")})
    public void accessLocaleFromView() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/access").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"View = [fr]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_introduction", id="mvc-context-locale")})
    public void accessLocaleFromViewEngine() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/access/view-engine").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"ViewEngine = [fr]"));
    }
}

