/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.application.context;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.application.context.MvcContextController;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class MvcContextTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(MvcContextController.class).addView("application/context/result.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_context", id="injection")})
    public void testMvcContextInjected() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/context");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"MvcContext injected = [true]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_context", id="injection")})
    public void testMvcContextAccessInformation() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/context");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"CSRF accessible = [true]"), (Matcher)CoreMatchers.containsString((String)"Path accessible = [true]"), (Matcher)CoreMatchers.containsString((String)"Config accessible = [true]"), (Matcher)CoreMatchers.containsString((String)"Encoders accessible = [true]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_context", id="request-scope")})
    public void testMvcContextScope() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/context");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"MvcContext scope = [javax.enterprise.context.RequestScoped]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_context", id="el-access")})
    public void testMvcContextAccessViaEl() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "mvc/application/context");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"MvcContext via EL = [true]"));
    }
}

