/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

public abstract class AbstractDoubleEncapsulatedExpressionStateObject
extends AbstractEncapsulatedExpressionStateObject {
    private StateObject firstStateObject;
    private StateObject secondStateObject;
    public static final String FIRST_STATE_OBJECT_PROPERTY = "firstStateObject";
    public static final String SECOND_STATE_OBJECT_PROPERTY = "secondStateObject";

    protected AbstractDoubleEncapsulatedExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected AbstractDoubleEncapsulatedExpressionStateObject(StateObject parent, StateObject firstStateObject, StateObject secondStateObject) {
        super(parent);
        this.firstStateObject = this.parent(firstStateObject);
        this.secondStateObject = this.parent(secondStateObject);
    }

    public AbstractDoubleEncapsulatedExpressionStateObject(StateObject parent, String firstJpqlFragment, String secondJpqlFragment) {
        super(parent);
        this.parseFirst(firstJpqlFragment);
        this.parseSecond(secondJpqlFragment);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.firstStateObject != null) {
            children.add(this.firstStateObject);
        }
        if (this.secondStateObject != null) {
            children.add(this.secondStateObject);
        }
    }

    @Override
    public AbstractDoubleEncapsulatedExpression getExpression() {
        return (AbstractDoubleEncapsulatedExpression)super.getExpression();
    }

    public StateObject getFirst() {
        return this.firstStateObject;
    }

    protected abstract String getFirstQueryBNFId();

    public StateObject getSecond() {
        return this.secondStateObject;
    }

    protected abstract String getSecondQueryBNFId();

    public boolean hasFirst() {
        return this.firstStateObject != null;
    }

    public boolean hasSecond() {
        return this.secondStateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            AbstractDoubleEncapsulatedExpressionStateObject encapsulated = (AbstractDoubleEncapsulatedExpressionStateObject)stateObject;
            return this.areEquivalent(this.firstStateObject, encapsulated.firstStateObject) && this.areEquivalent(this.secondStateObject, encapsulated.secondStateObject);
        }
        return false;
    }

    public void parseFirst(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getFirstQueryBNFId());
        this.setFirst((StateObject)stateObject);
    }

    public void parseSecond(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getSecondQueryBNFId());
        this.setSecond((StateObject)stateObject);
    }

    public void setFirst(StateObject firstStateObject) {
        StateObject oldFirstStateObject = this.firstStateObject;
        this.firstStateObject = this.parent(firstStateObject);
        this.firePropertyChanged(FIRST_STATE_OBJECT_PROPERTY, oldFirstStateObject, firstStateObject);
    }

    public void setSecond(StateObject secondStateObject) {
        StateObject oldSecondStateObject = this.firstStateObject;
        this.secondStateObject = this.parent(secondStateObject);
        this.firePropertyChanged(SECOND_STATE_OBJECT_PROPERTY, oldSecondStateObject, secondStateObject);
    }

    @Override
    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        if (this.firstStateObject != null) {
            this.firstStateObject.toString(writer);
            writer.append(' ');
        }
        writer.append(',');
        if (this.secondStateObject != null) {
            writer.append(' ');
            this.secondStateObject.toString(writer);
        }
    }
}

