/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;

public class EclipseLinkASMClassWriter
extends ClassWriter {
    private static final Logger LOG = Logger.getLogger(EclipseLinkASMClassWriter.class.getName());
    private final int version = EclipseLinkASMClassWriter.getLatestOPCodeVersion();
    private static final SortedMap<String, Integer> versionMap = Collections.unmodifiableSortedMap(new TreeMap<String, Integer>(){
        {
            this.put("1.7", 51);
            this.put("1.8", 52);
            this.put("9", 53);
            this.put("10", 54);
            this.put("11", 55);
            this.put("12", 56);
            this.put("13", 57);
            this.put("14", 58);
            this.put("15", 59);
            this.put("16", 60);
            this.put("17", 61);
        }
    });

    public EclipseLinkASMClassWriter() {
        this(2);
    }

    public EclipseLinkASMClassWriter(int flags) {
        super(flags);
    }

    public final void visit(int access, String name, String signature, String superName, String[] interfaces) {
        this.visit(this.version, access, name, signature, superName, interfaces);
    }

    private static int getLatestOPCodeVersion() {
        String v;
        block9: {
            v = versionMap.firstKey();
            if (System.getSecurityManager() == null) {
                v = System.getProperty("java.specification.version");
            } else {
                try {
                    v = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("java.specification.version");
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Cannot read 'java.specification.version' property.", t);
                    if (!LOG.isLoggable(Level.FINE)) break block9;
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", v);
                }
            }
        }
        Integer version = (Integer)versionMap.get(v);
        if (version == null) {
            String latest = versionMap.lastKey();
            if (latest.compareTo(v) < 0) {
                LOG.log(Level.WARNING, "Java SE ''{0}'' is not fully supported yet. Report this error to the EclipseLink open source project.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", latest);
                }
                version = (Integer)versionMap.get(latest);
            } else {
                String key = versionMap.firstKey();
                LOG.log(Level.WARNING, "Java SE ''{0}'' is too old.", v);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Generating bytecode for Java SE ''{0}''.", key);
                }
                version = (Integer)versionMap.get(key);
            }
        }
        return version;
    }
}

