/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.beans.Beans;
import java.util.Iterator;
import java.util.List;

public final class Label
extends UIOutput
implements NamingContainer {
    public static final String REQUIRED_ID = "_required";
    public static final String REQUIRED_FACET = "required";
    public static final String ERROR_ID = "_error";
    public static final String ERROR_FACET = "error";
    private EditableValueHolder labeledComponent = null;
    private String element = "span";
    private static final boolean DEBUG = false;
    private String forComp = null;
    private boolean hideIndicators = false;
    private boolean hideIndicatorsSet = false;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevelSet = false;
    private String onClick = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private boolean requiredIndicator = false;
    private boolean requiredIndicatorSet = false;
    private String style = null;
    private String styleClass = null;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Label() {
        this.setRendererType("com.sun.webui.jsf.Label");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Label";
    }

    public void setConverter(Converter converter) {
        super.setConverter(converter);
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setLabeledComponent(UIComponent comp) {
        if (comp == null) {
            this.labeledComponent = null;
        } else if (comp instanceof EditableValueHolder) {
            this.labeledComponent = (EditableValueHolder)comp;
            if (!Beans.isDesignTime()) {
                this.setFor(comp.getClientId(FacesContext.getCurrentInstance()));
            }
            this.element = "label";
        } else {
            if (LogUtil.infoEnabled(Label.class)) {
                FacesContext context = FacesContext.getCurrentInstance();
                LogUtil.info(Label.class, "Label.invalidFor", new Object[]{this.getId(), context.getViewRoot().getViewId(), comp.getId()});
            }
            this.labeledComponent = null;
            this.element = "label";
        }
    }

    public EditableValueHolder getLabeledComponent() {
        if (this.labeledComponent != null) {
            return this.labeledComponent;
        }
        String id = this.getFor();
        if (id == null) {
            this.setLabeledComponent(this.findLabeledChild());
        } else {
            if (id.contains(":") && !id.startsWith(":")) {
                id = ":" + id;
            }
            try {
                UIComponent parent = this.getParent();
                this.setLabeledComponent(parent.findComponent(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.element = "label";
        }
        return this.labeledComponent;
    }

    public String getLabeledComponentId(FacesContext context) {
        String id;
        if (this.labeledComponent != null) {
            if (this.labeledComponent instanceof ComplexComponent) {
                ComplexComponent compComp = (ComplexComponent)this.labeledComponent;
                id = compComp.getPrimaryElementID(context);
            } else {
                UIComponent comp = (UIComponent)this.labeledComponent;
                id = comp.getClientId(context);
            }
        } else {
            UIComponent comp;
            id = this.getFor();
            if (id != null && !id.contains(":") && (comp = this.getParent()) instanceof NamingContainer) {
                id = comp.getClientId(context) + ":" + id;
            }
        }
        return id;
    }

    private UIComponent findLabeledChild() {
        List kids = this.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            Object kid = kids.get(i);
            if (!(kid instanceof EditableValueHolder)) continue;
            return (UIComponent)kid;
        }
        return null;
    }

    public UIComponent getRequiredIcon(Theme theme, FacesContext context) {
        UIComponent comp = this.getFacet(REQUIRED_FACET);
        if (comp != null) {
            return comp;
        }
        Icon icon = ThemeUtilities.getIcon(theme, "LABEL_REQUIRED_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REQUIRED_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        return icon;
    }

    public UIComponent getErrorIcon(Theme theme, FacesContext context, boolean valid) {
        UIComponent comp = this.getFacet(ERROR_FACET);
        if (comp != null) {
            return comp;
        }
        Icon icon = ThemeUtilities.getIcon(theme, "LABEL_INVALID_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, ERROR_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        if (valid) {
            icon.setIcon("DOT");
            icon.setAlt("");
        } else if (this.labeledComponent != null) {
            String labeledCompID = ((UIComponent)this.labeledComponent).getClientId(context);
            Iterator messages = context.getMessages(labeledCompID);
            StringBuilder msgBuffer = new StringBuilder();
            while (messages.hasNext()) {
                FacesMessage fm = (FacesMessage)messages.next();
                msgBuffer.append(fm.getDetail());
                msgBuffer.append(" ");
            }
            icon.setToolTip(msgBuffer.toString());
        }
        return icon;
    }

    public String getElement() {
        return this.element;
    }

    private static void log(String msg) {
        LogUtil.finest(Label.class.getName() + "::" + msg);
    }

    public int getLabelLevel() {
        int level = this.doGetLabelLevel();
        if (level < 1 || level > 3) {
            level = 2;
            this.setLabelLevel(level);
        }
        return level;
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("text")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("text")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public String getFor() {
        if (this.forComp != null) {
            return this.forComp;
        }
        ValueExpression vb = this.getValueExpression("for");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFor(String newForcomp) {
        this.forComp = newForcomp;
    }

    public boolean isHideIndicators() {
        if (this.hideIndicatorsSet) {
            return this.hideIndicators;
        }
        ValueExpression vb = this.getValueExpression("hideIndicators");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setHideIndicators(boolean newHideIndicators) {
        this.hideIndicators = newHideIndicators;
        this.hideIndicatorsSet = true;
    }

    public int doGetLabelLevel() {
        if (this.labelLevelSet) {
            return this.labelLevel;
        }
        ValueExpression vb = this.getValueExpression("labelLevel");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 2;
    }

    public void setLabelLevel(int newLabelLevel) {
        this.labelLevel = newLabelLevel;
        this.labelLevelSet = true;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public boolean isRequiredIndicator() {
        if (this.requiredIndicatorSet) {
            return this.requiredIndicator;
        }
        ValueExpression vb = this.getValueExpression("requiredIndicator");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setRequiredIndicator(boolean newRequiredIndicator) {
        this.requiredIndicator = newRequiredIndicator;
        this.requiredIndicatorSet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public Object getText() {
        return this.getValue();
    }

    public void setText(Object newText) {
        this.setValue(newText);
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.forComp = (String)values[1];
        this.hideIndicators = (Boolean)values[2];
        this.hideIndicatorsSet = (Boolean)values[3];
        this.labelLevel = (Integer)values[4];
        this.labelLevelSet = (Boolean)values[5];
        this.onClick = (String)values[6];
        this.onMouseDown = (String)values[7];
        this.onMouseMove = (String)values[8];
        this.onMouseOut = (String)values[9];
        this.onMouseOver = (String)values[10];
        this.onMouseUp = (String)values[11];
        this.requiredIndicator = (Boolean)values[12];
        this.requiredIndicatorSet = (Boolean)values[13];
        this.style = (String)values[14];
        this.styleClass = (String)values[15];
        this.toolTip = (String)values[16];
        this.visible = (Boolean)values[17];
        this.visibleSet = (Boolean)values[18];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.forComp, this.hideIndicators ? Boolean.TRUE : Boolean.FALSE, this.hideIndicatorsSet ? Boolean.TRUE : Boolean.FALSE, this.labelLevel, this.labelLevelSet ? Boolean.TRUE : Boolean.FALSE, this.onClick, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.requiredIndicator ? Boolean.TRUE : Boolean.FALSE, this.requiredIndicatorSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

