/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.methodreference;

import com.sun.ts.tests.el.common.api.expression.ExpressionTest;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.Fault;
import com.sun.ts.tests.el.common.util.MethodsBean;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String NL = System.getProperty("line.seperator", "\n");
    private Properties testProps = System.getProperties();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void methodReferenceTest() throws Fault {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression mexp1 = expFactory.createMethodExpression(context, "#{bean.targetF('aaa',1234)}", String.class, null);
            MethodInfo minfo1 = mexp1.getMethodInfo(context);
            MethodReference mref1 = mexp1.getMethodReference(context);
            pass1 = ExpressionTest.testMethodReference(mref1, bean, minfo1, new Class[]{Deprecated.class}, new Object[]{"aaa", 1234L}, buf);
            try {
                mexp1.getMethodReference(null);
                pass2 = false;
                buf.append("Did not get expected NullPointerException for null context." + NL);
            }
            catch (NullPointerException npe) {
                pass2 = true;
            }
            MethodExpression mexp3 = expFactory.createMethodExpression(context, "#{noSuchBean.method()}", String.class, null);
            try {
                mexp3.getMethodReference(context);
                pass3 = false;
                buf.append("Did not get expected PropertyNotFoundException return for unknown bean." + NL);
            }
            catch (PropertyNotFoundException pnfe) {
                pass3 = true;
            }
            MethodExpression mexp4 = expFactory.createMethodExpression(context, "#{bean.noSuchMethod()}", String.class, null);
            try {
                mexp4.getMethodReference(context);
                pass4 = false;
                buf.append("Did not get expected MethodNotFoundException return for unknown bean." + NL);
            }
            catch (MethodNotFoundException mnfe) {
                pass4 = true;
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Test getMethodReference threw an Exception!" + ELTestUtil.NL + "Received: " + ex.toString() + ELTestUtil.NL);
            ex.printStackTrace();
            throw new Fault(ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Fault("Test FAILED" + NL + buf.toString());
        }
    }
}

