/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.relationaloperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.TestNum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private List<Object> numberList = TestNum.getNumberList();
    private static final DougType DT = new DougType();
    private static final NickType NT = new NickType();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elEqualOperandLessThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            String expr1 = ExprEval.buildElExpr(false, "<=");
            logger.log(System.Logger.Level.TRACE, "first expression to be evaluated is " + expr1);
            NameValuePair[] values1 = NameValuePair.buildNameValuePair(Float.valueOf(-1.0f), Float.valueOf(-1.0f));
            Object result1 = ExprEval.evaluateValueExpression(expr1, values1, Boolean.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            String expr2 = ExprEval.buildElExpr(true, "le");
            logger.log(System.Logger.Level.TRACE, "second expression to be evaluated is " + expr2);
            NameValuePair[] values2 = NameValuePair.buildNameValuePair(new BigDecimal("1.0"), BigDecimal.ONE);
            Object result2 = ExprEval.evaluateValueExpression(expr2, values2, Boolean.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elEqualOperandGreaterThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            String expr1 = ExprEval.buildElExpr(false, ">=");
            logger.log(System.Logger.Level.TRACE, "first expression to be evaluated is " + expr1);
            NameValuePair[] values1 = NameValuePair.buildNameValuePair(Float.valueOf(-1.0f), Float.valueOf(-1.0f));
            Object result1 = ExprEval.evaluateValueExpression(expr1, values1, Boolean.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            String expr2 = ExprEval.buildElExpr(true, "ge");
            logger.log(System.Logger.Level.TRACE, "second expression to be evaluated is " + expr2);
            NameValuePair[] values2 = NameValuePair.buildNameValuePair(new BigInteger("1010"), BigInteger.TEN);
            Object result2 = ExprEval.evaluateValueExpression(expr2, values2, Boolean.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandLessThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 <= nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            Object result2 = ExprEval.evaluateValueExpression("#{2 le nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandGreaterThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 >= nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            Object result2 = ExprEval.evaluateValueExpression("#{2 ge nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandNotEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 != nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            Object result2 = ExprEval.evaluateValueExpression("#{2 ne nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullOperandEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 == nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "first result is " + result1.toString());
            Object result2 = ExprEval.evaluateValueExpression("#{2 eq nullValue}", null, Object.class);
            logger.log(System.Logger.Level.TRACE, "second result is " + result2.toString());
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elBigDecimalLessThanTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.FALSE, "<");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), Boolean.FALSE, "lt");
        this.testOperatorBoolean(BigDecimal.valueOf(0.531), Boolean.TRUE, "lt");
    }

    @Test
    public void elBigDecimalLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.FALSE, "<=");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), Boolean.TRUE, "le");
        this.testOperatorBoolean(BigDecimal.valueOf(-10.531), Boolean.TRUE, "<=");
    }

    @Test
    public void elBigDecimalGreaterThanTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.TRUE, ">");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), Boolean.FALSE, ">");
        this.testOperatorBoolean(BigDecimal.valueOf(0.531), Boolean.FALSE, "gt");
    }

    @Test
    public void elBigDecimalGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.TRUE, ">=");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), Boolean.TRUE, "ge");
        this.testOperatorBoolean(BigDecimal.valueOf(-1.0), Boolean.FALSE, "ge");
    }

    @Test
    public void elBigDecimalEqualToTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.FALSE, "==");
        this.testOperatorBoolean(BigDecimal.valueOf(1L), Boolean.TRUE, "eq");
    }

    @Test
    public void elBigDecimalNotEqualToTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), Boolean.TRUE, "!=");
        this.testOperatorBoolean(BigDecimal.valueOf(1L), Boolean.FALSE, "ne");
    }

    @Test
    public void elFloatLessThanTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10.0f), Boolean.FALSE, "<");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.FALSE, "<");
        this.testOperatorBoolean(Float.valueOf(-10.0f), Boolean.TRUE, "lt");
    }

    @Test
    public void elFloatLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10.0f), Boolean.FALSE, "<=");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.TRUE, "le");
        this.testOperatorBoolean(Float.valueOf(-10.0f), Boolean.TRUE, "<=");
    }

    @Test
    public void elFloatGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), Boolean.TRUE, ">");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.FALSE, ">");
        this.testOperatorBoolean(Float.valueOf(-531.0f), Boolean.FALSE, "gt");
    }

    @Test
    public void elFloatGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), Boolean.TRUE, ">=");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.TRUE, "ge");
        this.testOperatorBoolean(Float.valueOf(-1.0f), Boolean.FALSE, "ge");
    }

    @Test
    public void elFloatEqualToTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), Boolean.FALSE, "==");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.TRUE, "eq");
    }

    @Test
    public void elFloatNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), Boolean.TRUE, "!=");
        this.testOperatorBoolean(Float.valueOf(1.0f), Boolean.FALSE, "ne");
    }

    @Test
    public void elDoubleLessThanTest() throws Exception {
        this.testOperatorBoolean(2.5, Boolean.FALSE, "<");
        this.testOperatorBoolean(1.0, Boolean.FALSE, "lt");
        this.testOperatorBoolean(-2.5, Boolean.TRUE, "lt");
    }

    @Test
    public void elDoubleLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(2.5, Boolean.FALSE, "<=");
        this.testOperatorBoolean(1.0, Boolean.TRUE, "le");
        this.testOperatorBoolean(-1.5, Boolean.TRUE, "<=");
    }

    @Test
    public void elDoubleGreaterThanTest() throws Exception {
        this.testOperatorBoolean(10.5, Boolean.TRUE, ">");
        this.testOperatorBoolean(1.0, Boolean.FALSE, "gt");
        this.testOperatorBoolean(-10.5, Boolean.FALSE, "gt");
    }

    @Test
    public void elDoubleGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(10.0, Boolean.TRUE, ">=");
        this.testOperatorBoolean(1.0, Boolean.TRUE, "ge");
        this.testOperatorBoolean(-10.0, Boolean.FALSE, "ge");
    }

    @Test
    public void elDoubleEqualToTest() throws Exception {
        this.testOperatorBoolean(10531.0, Boolean.FALSE, "==");
        this.testOperatorBoolean(1.0, Boolean.TRUE, "eq");
    }

    @Test
    public void elDoubleNotEqualToTest() throws Exception {
        this.testOperatorBoolean(10531.0, Boolean.TRUE, "!=");
        this.testOperatorBoolean(1.0, Boolean.FALSE, "ne");
    }

    @Test
    public void elBigIntegerLessThanTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.FALSE, "<");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.FALSE, "lt");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), Boolean.TRUE, "lt");
    }

    @Test
    public void elBigIntegerLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.FALSE, "<=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.TRUE, "le");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), Boolean.TRUE, "<=");
    }

    @Test
    public void elBigIntegerGreaterThanTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.TRUE, ">");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.FALSE, "gt");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), Boolean.FALSE, "gt");
    }

    @Test
    public void elBigIntegerGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.TRUE, ">=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.TRUE, "ge");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), Boolean.FALSE, "ge");
    }

    @Test
    public void elBigIntegerEqualToTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.FALSE, "==");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.TRUE, "eq");
    }

    @Test
    public void elBigIntegerNotEqualToTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), Boolean.TRUE, "!=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), Boolean.FALSE, "ne");
    }

    @Test
    public void elLongLessThanTest() throws Exception {
        this.testOperatorBoolean(25000L, Boolean.FALSE, "<");
        this.testOperatorBoolean(1L, Boolean.FALSE, "<");
        this.testOperatorBoolean(-25000L, Boolean.TRUE, "lt");
    }

    @Test
    public void elLongLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(25000L, Boolean.FALSE, "<=");
        this.testOperatorBoolean(1L, Boolean.TRUE, "le");
        this.testOperatorBoolean(-25000L, Boolean.TRUE, "<=");
    }

    @Test
    public void elLongGreaterThanTest() throws Exception {
        this.testOperatorBoolean(10531L, Boolean.TRUE, ">");
        this.testOperatorBoolean(1L, Boolean.FALSE, ">");
        this.testOperatorBoolean(-10531L, Boolean.FALSE, "gt");
    }

    @Test
    public void elLongGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(25000L, Boolean.TRUE, ">=");
        this.testOperatorBoolean(1L, Boolean.TRUE, "ge");
        this.testOperatorBoolean(-25000L, Boolean.FALSE, "ge");
    }

    @Test
    public void elLongEqualToTest() throws Exception {
        this.testOperatorBoolean(25000L, Boolean.FALSE, "==");
        this.testOperatorBoolean(1L, Boolean.TRUE, "eq");
    }

    @Test
    public void elLongNotEqualToTest() throws Exception {
        this.testOperatorBoolean(25000L, Boolean.TRUE, "!=");
        this.testOperatorBoolean(1L, Boolean.FALSE, "ne");
    }

    @Test
    public void elIntegerLessThanTest() throws Exception {
        this.testOperatorBoolean(25, Boolean.FALSE, "<");
        this.testOperatorBoolean(1, Boolean.FALSE, "lt");
        this.testOperatorBoolean(-25, Boolean.TRUE, "lt");
    }

    @Test
    public void elIntegerLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(25, Boolean.FALSE, "<=");
        this.testOperatorBoolean(1, Boolean.TRUE, "le");
        this.testOperatorBoolean(-25, Boolean.TRUE, "<=");
    }

    @Test
    public void elIntegerGreaterThanTest() throws Exception {
        this.testOperatorBoolean(105, Boolean.TRUE, ">");
        this.testOperatorBoolean(1, Boolean.FALSE, "gt");
        this.testOperatorBoolean(-105, Boolean.FALSE, "gt");
    }

    @Test
    public void elIntegerGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(250, Boolean.TRUE, ">=");
        this.testOperatorBoolean(1, Boolean.TRUE, "ge");
        this.testOperatorBoolean(-250, Boolean.FALSE, "ge");
    }

    @Test
    public void elIntegerEqualToTest() throws Exception {
        this.testOperatorBoolean(25, Boolean.FALSE, "==");
        this.testOperatorBoolean(1, Boolean.TRUE, "eq");
    }

    @Test
    public void elIntegerNotEqualToTest() throws Exception {
        this.testOperatorBoolean(25, Boolean.TRUE, "!=");
        this.testOperatorBoolean(1, Boolean.FALSE, "ne");
    }

    @Test
    public void elShortLessThanTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.FALSE, "<");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.FALSE, "<");
        this.testOperatorBoolean(Short.valueOf("-2"), Boolean.TRUE, "lt");
    }

    @Test
    public void elShortLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.FALSE, "<=");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.TRUE, "le");
        this.testOperatorBoolean(Short.valueOf("-2"), Boolean.TRUE, "<=");
    }

    @Test
    public void elShortGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.TRUE, ">");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.FALSE, ">");
        this.testOperatorBoolean(Short.valueOf("-2"), Boolean.FALSE, "gt");
    }

    @Test
    public void elShortGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.TRUE, ">=");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.TRUE, "ge");
        this.testOperatorBoolean(Short.valueOf("-2"), Boolean.FALSE, "ge");
    }

    @Test
    public void elShortEqualToTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.FALSE, "==");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.TRUE, "eq");
    }

    @Test
    public void elShortNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), Boolean.TRUE, "!=");
        this.testOperatorBoolean(Short.valueOf("1"), Boolean.FALSE, "ne");
    }

    @Test
    public void elByteLessThanTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.FALSE, "<");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.FALSE, "lt");
        this.testOperatorBoolean(Byte.valueOf("-2"), Boolean.TRUE, "lt");
    }

    @Test
    public void elByteLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.FALSE, "<=");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.TRUE, "le");
        this.testOperatorBoolean(Byte.valueOf("-2"), Boolean.TRUE, "<=");
    }

    @Test
    public void elByteGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.TRUE, ">");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.FALSE, "gt");
        this.testOperatorBoolean(Byte.valueOf("-2"), Boolean.FALSE, "gt");
    }

    @Test
    public void elByteGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.TRUE, ">=");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.TRUE, "ge");
        this.testOperatorBoolean(Byte.valueOf("-2"), Boolean.FALSE, "ge");
    }

    @Test
    public void elByteEqualToTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.FALSE, "==");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.TRUE, "eq");
    }

    @Test
    public void elByteNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), Boolean.TRUE, "!=");
        this.testOperatorBoolean(Byte.valueOf("1"), Boolean.FALSE, "ne");
    }

    @Test
    public void elStringLessThanTest() throws Exception {
        this.testOperatorBoolean("Alpha", DT, Boolean.TRUE, "<");
        this.testOperatorBoolean("Beta", DT, Boolean.FALSE, "lt");
        this.testOperatorBoolean("Gamma", DT, Boolean.FALSE, "lt");
    }

    @Test
    public void elStringLessThanEqualTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, Boolean.FALSE, "<=");
        this.testOperatorBoolean("Beta", DT, Boolean.TRUE, "le");
        this.testOperatorBoolean("Alpha", DT, Boolean.TRUE, "<=");
    }

    @Test
    public void elStringGreaterThanTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, Boolean.TRUE, ">");
        this.testOperatorBoolean("Beta", DT, Boolean.FALSE, "gt");
        this.testOperatorBoolean("Alpha", DT, Boolean.FALSE, "gt");
    }

    @Test
    public void elStringGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, Boolean.TRUE, ">=");
        this.testOperatorBoolean("Beta", DT, Boolean.TRUE, "ge");
        this.testOperatorBoolean("Alpha", DT, Boolean.FALSE, "ge");
    }

    @Test
    public void elStringEqualToTest() throws Exception {
        this.testOperatorBoolean("Beta", DT, Boolean.TRUE, "==");
        this.testOperatorBoolean("Alpha", DT, Boolean.FALSE, "eq");
    }

    @Test
    public void elStringNotEqualToTest() throws Exception {
        this.testOperatorBoolean("Alpha", DT, Boolean.TRUE, "!=");
        this.testOperatorBoolean("Beta", DT, Boolean.FALSE, "ne");
    }

    @Test
    public void elOtherLessThanTest() throws Exception {
        this.testOperatorBoolean(DT, NT, Boolean.TRUE, "<");
        this.testOperatorBoolean(DT, DT, Boolean.FALSE, "lt");
        this.testOperatorBoolean(NT, DT, Boolean.FALSE, "lt");
    }

    @Test
    public void elOtherLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(NT, DT, Boolean.FALSE, "<=");
        this.testOperatorBoolean(DT, DT, Boolean.TRUE, "le");
        this.testOperatorBoolean(DT, NT, Boolean.TRUE, "<=");
    }

    @Test
    public void elOtherGreaterThanTest() throws Exception {
        this.testOperatorBoolean(NT, DT, Boolean.TRUE, ">");
        this.testOperatorBoolean(DT, DT, Boolean.FALSE, "gt");
        this.testOperatorBoolean(DT, NT, Boolean.FALSE, "gt");
    }

    @Test
    public void elOtherGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(NT, DT, Boolean.TRUE, ">=");
        this.testOperatorBoolean(DT, DT, Boolean.TRUE, "ge");
        this.testOperatorBoolean(DT, NT, Boolean.FALSE, "ge");
    }

    @Test
    public void elOtherEqualToTest() throws Exception {
        this.testOperatorBoolean(DT, DT, Boolean.TRUE, "==");
        this.testOperatorBoolean(DT, NT, Boolean.FALSE, "eq");
    }

    @Test
    public void elOtherNotEqualToTest() throws Exception {
        this.testOperatorBoolean(DT, NT, Boolean.TRUE, "!=");
        this.testOperatorBoolean(DT, DT, Boolean.FALSE, "ne");
    }

    @Test
    public void elBooleanEqualToTest() throws Exception {
        this.testOperatorBoolean("true", Boolean.TRUE, Boolean.TRUE, "==");
        this.testOperatorBoolean("false", Boolean.TRUE, Boolean.FALSE, "eq");
    }

    @Test
    public void elBooleanNotEqualToTest() throws Exception {
        this.testOperatorBoolean("false", Boolean.TRUE, Boolean.TRUE, "!=");
        this.testOperatorBoolean("false", Boolean.FALSE, Boolean.FALSE, "ne");
    }

    @Test
    public void elEnumEqualToTest() throws Exception {
        this.testOperatorBoolean((Object)TestEnum.APPLE, "APPLE", Boolean.TRUE, "==");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "PEAR", Boolean.TRUE, "eq");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "APPLE", Boolean.FALSE, "==");
        this.testOperatorBoolean((Object)TestEnum.APPLE, "PEAR", Boolean.FALSE, "eq");
    }

    @Test
    public void elEnumNotEqualToTest() throws Exception {
        this.testOperatorBoolean((Object)TestEnum.APPLE, "PEAR", Boolean.TRUE, "!=");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "APPLE", Boolean.TRUE, "ne");
        this.testOperatorBoolean((Object)TestEnum.APPLE, "APPLE", Boolean.FALSE, "!=");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "PEAR", Boolean.FALSE, "ne");
    }

    private void testOperatorBoolean(BigDecimal testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"BigDecimal\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are BigDecimal and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"BigDecimal\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(BigInteger testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"BigInteger\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are BigInteger and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"BigInteger\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Float testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Float\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Float and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Float\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Double testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Double\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Double and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Double\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Long testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Long\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof BigInteger || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Long and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Long\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Integer testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Integer\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof BigInteger || testNum instanceof Long || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Integer and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Integer\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Short testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Short\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Short) && !(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Short and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Short\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Byte testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            logger.log(System.Logger.Level.TRACE, "*** Start \"Byte\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                logger.log(System.Logger.Level.TRACE, "Skip " + skipType + " Data type already tested for this in the " + skipType + " tests.");
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
                logger.log(System.Logger.Level.TRACE, "types are Byte and " + testNum.getClass().getName());
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                logger.log(System.Logger.Level.TRACE, "*** End \"Byte\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Object testValOne, Object testValTwo, Boolean expectedVal, String booleanOperator) throws Exception {
        boolean pass;
        NameValuePair[] values = NameValuePair.buildNameValuePair(testValOne, testValTwo);
        try {
            logger.log(System.Logger.Level.TRACE, "*** Start \"String\" Test Sequence ***");
            String expr = ExprEval.buildElExpr(false, booleanOperator);
            logger.log(System.Logger.Level.TRACE, "expression to be evaluated is " + expr);
            logger.log(System.Logger.Level.TRACE, "types are String and String");
            Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
            logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
            pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            logger.log(System.Logger.Level.TRACE, "*** End \"String\" Test Sequence ***");
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private static class DougType
    implements Comparable<Object> {
        private DougType() {
        }

        public String toString() {
            return "Beta";
        }

        @Override
        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof DougType;
        }

        public int hashCode() {
            return 42;
        }
    }

    private static class NickType
    implements Comparable<Object> {
        private NickType() {
        }

        public String toString() {
            return "Gamma";
        }

        @Override
        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof NickType;
        }

        public int hashCode() {
            return 42;
        }
    }

    private static enum TestEnum {
        APPLE,
        PEAR;

    }
}

