/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidLineItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.ValidWarehouseItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.LineItem;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.model.WarehouseItem;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ExecutableValidationIgnoresValidatedExecutableAnnotationSettingsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ExecutableValidationIgnoresValidatedExecutableAnnotationSettingsTest.webArchiveBuilder().withTestClass(ExecutableValidationIgnoresValidatedExecutableAnnotationSettingsTest.class)).withClass(LineItem.class)).withClass(WarehouseItem.class)).withClass(ValidLineItem.class)).withClass(ValidWarehouseItem.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        LineItem object = new LineItem(null);
        String methodName = "setName";
        Method method = LineItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        Constructor constructor = LineItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(LineItem.class).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        LineItem object = new LineItem(null);
        String methodName = "setName";
        Method method = LineItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnTypeLevel() throws Exception {
        Constructor constructor = LineItem.class.getConstructor(String.class);
        LineItem createdObject = new LineItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidLineItem.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(LineItem.class).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        WarehouseItem object = new WarehouseItem(null);
        String methodName = "setName";
        Method method = WarehouseItem.class.getMethod(methodName, String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorParametersYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        Constructor constructor = WarehouseItem.class.getConstructor(String.class);
        Object[] parameterValues = new Object[]{null};
        Set violations = this.getExecutableValidator().validateConstructorParameters(constructor, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(WarehouseItem.class).parameter("name", 0)));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        WarehouseItem object = new WarehouseItem(null);
        String methodName = "setName";
        Method method = WarehouseItem.class.getMethod(methodName, String.class);
        Object returnValue = null;
        Set violations = this.getExecutableValidator().validateReturnValue((Object)object, method, returnValue, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withPropertyPath(ConstraintViolationAssert.pathWith().method(methodName).returnValue()));
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-methodlevelvalidationmethods", id="m")
    public void testValidateConstructorReturnValueYieldsConstraintViolationIfValidateExecutableIsSetToNONEOnExecutableLevel() throws Exception {
        Constructor constructor = WarehouseItem.class.getConstructor(String.class);
        WarehouseItem createdObject = new WarehouseItem(null);
        Set violations = this.getExecutableValidator().validateConstructorReturnValue(constructor, (Object)createdObject, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidWarehouseItem.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(WarehouseItem.class).returnValue()));
    }
}

