/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition;

import jakarta.validation.Configuration;
import jakarta.validation.Validator;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition.DummyLengthValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition.LengthValidator;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition.Name;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class XmlConfiguredConstraintValidatorTest
extends AbstractTCKTest {
    public static final String packageName = "/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdefinition/";
    public static final String mappingFile1 = "constraint-definition-ExludeExistingValidatorsTest.xml";
    public static final String mappingFile2 = "constraint-definition-IncludeExistingValidatorsTest.xml";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)XmlConfiguredConstraintValidatorTest.webArchiveBuilder().withTestClassPackage(XmlConfiguredConstraintValidatorTest.class)).withResource(mappingFile1)).withResource(mappingFile2)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-constraintdescriptor", id="o"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="b"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="e")})
    public <T extends Annotation> void testExcludeExistingValidators() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-ExludeExistingValidatorsTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        PropertyDescriptor propDescriptor = validator.getConstraintsForClass(Name.class).getConstraintsForProperty("name");
        Set descriptors = propDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should only be one constraint.");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        List validators = descriptor.getConstraintValidatorClasses();
        Assert.assertEquals((int)validators.size(), (int)0, (String)"No xml defined validator and annotations are ignored -> no validator");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-constraintdescriptor", id="o"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="c"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="d"), @SpecAssertion(section="xml-mapping-constraintdefinition", id="e")})
    public <T extends Annotation> void testIncludeExistingValidators() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(TestUtil.getInputStreamForPath("/org/hibernate/beanvalidation/tck/tests/xmlconfiguration/constraintdefinition/constraint-definition-IncludeExistingValidatorsTest.xml"));
        Validator validator = config.buildValidatorFactory().getValidator();
        PropertyDescriptor propDescriptor = validator.getConstraintsForClass(Name.class).getConstraintsForProperty("name");
        Set descriptors = propDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should only be one constraint.");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        List validators = descriptor.getConstraintValidatorClasses();
        Assert.assertEquals((int)validators.size(), (int)2, (String)"One validator should be defined in annotation and one in xml");
        Assert.assertTrue((boolean)validators.contains(LengthValidator.class), (String)"Validator configured in annotation should be present");
        Assert.assertTrue((boolean)validators.contains(DummyLengthValidator.class), (String)"Validator configured via XML should be present");
    }
}

