/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.executable;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Calendar;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.AnnotatedCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.AnotherBookingService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.AnotherShipmentService2stInHierarchy;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.BookingService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.CalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.CalendarServiceWithCascadingReturnValue;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ClassLevelAnnotatedCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.CrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.DeliveryServiceImpl;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.Event;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.NameProducer;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.Order;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.OrderService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.PersonService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ShipmentService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ShipmentServiceSubClass;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.UserService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ValidAnotherBookingService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.ValidPersonService;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ExecutableValidationTest
extends AbstractTCKTest {
    @Inject
    private CalendarService calendar;
    @Inject
    private CalendarServiceWithCascadingReturnValue cascadingCalendar;
    @Inject
    private BookingService bookingService;
    @Inject
    private Instance<AnotherBookingService> anotherBookingService;
    @Inject
    private NameProducer nameProducer;
    @Inject
    private AnnotatedCalendarService annotatedCalendar;
    @Inject
    private ClassLevelAnnotatedCalendarService classLevelAnnotatedCalendar;
    @Inject
    private Instance<UserService> userServiceInstance;
    @Inject
    private Instance<PersonService> personServiceInstance;
    @Inject
    private OrderService orderService;
    @Inject
    private ShipmentService shipmentService;
    @Inject
    private ShipmentServiceSubClass shipmentServiceSubClass;
    @Inject
    private AnotherShipmentService2stInHierarchy anotherShipmentService;
    @Inject
    private DeliveryServiceImpl deliveryService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ExecutableValidationTest.webArchiveBuilder().withTestClassPackage(ExecutableValidationTest.class)).withBeansXml().build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testParameterValidationOfConstrainedMethod() {
        try {
            Calendar endDate = Calendar.getInstance();
            endDate.set(1980, 1, 1);
            this.calendar.createEvent(null, endDate.getTime());
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class), ConstraintViolationAssert.violationOf(Future.class), ConstraintViolationAssert.violationOf(CrossParameterConstraint.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testReturnValueValidationOfConstrainedMethod() {
        try {
            this.calendar.createEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testCascadedReturnValueValidationOfConstrainedMethod() {
        try {
            this.cascadingCalendar.createValidEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testGettersAreNotValidatedByDefault() {
        Event event = this.calendar.getEvent();
        Assert.assertNull((Object)event, (String)"The event should be null, since getters are not validated by default.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testParameterValidationOfConstrainedConstructor() {
        try {
            this.nameProducer.setName("Bob");
            this.userServiceInstance.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class), ConstraintViolationAssert.violationOf(CrossParameterConstraint.class));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="integration-general-executable", id="a"), @SpecAssertion(section="integration-general-executable", id="b"), @SpecAssertion(section="integration-general-executable", id="c"), @SpecAssertion(section="integration-dependencyinjection", id="a")})
    public void testReturnValueValidationOfConstrainedConstructor() {
        try {
            this.personServiceInstance.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidPersonService.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="e")
    public void testValidationOfConstrainedMethodAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.annotatedCalendar.createEvent(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="e")
    public void testValidationOfConstrainedMethodAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Event event = this.annotatedCalendar.createEvent(-10);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="f")
    public void testValidationOfConstrainedMethodOnClassAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.classLevelAnnotatedCalendar.getEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="f")
    public void testValidationOfConstrainedMethodOnClassAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Event event = this.classLevelAnnotatedCalendar.createEvent(null);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="f")
    public void testValidationOfConstrainedMethodOnInterfaceAnnotatedWithValidateOnExecutionContainingExecutableType() {
        try {
            this.orderService.getOrder();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="f")
    public void testValidationOfConstrainedMethodOnInterfaceAnnotatedWithValidateOnExecutionNotContainingExecutableType() {
        Order order = this.orderService.placeOrder(null);
        Assert.assertNotNull((Object)order);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-triggeringmethodvalidation", id="a"), @SpecAssertion(section="validationapi-triggeringmethodvalidation", id="b")})
    public void testMethodValidationInvokesParameterAndReturnValueValidationUsingDefaultGroup() {
        try {
            this.bookingService.placeBooking("9999");
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        }
        Assert.assertEquals((int)this.bookingService.getInvocationCount(), (int)0);
        try {
            this.bookingService.placeBooking("10000");
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(DecimalMin.class));
        }
        Assert.assertEquals((int)this.bookingService.getInvocationCount(), (int)1);
        String booking = this.bookingService.placeBooking("10001");
        Assert.assertEquals((String)booking, (String)"10001");
        Assert.assertEquals((int)this.bookingService.getInvocationCount(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-triggeringmethodvalidation", id="a"), @SpecAssertion(section="validationapi-triggeringmethodvalidation", id="b")})
    public void testConstructorValidationInvokesParameterAndReturnValueValidationUsingDefaultGroup() {
        this.nameProducer.setName("9999");
        try {
            this.anotherBookingService.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        }
        Assert.assertEquals((int)AnotherBookingService.getInvocationCount(), (int)0);
        this.nameProducer.setName("10000");
        try {
            this.anotherBookingService.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidAnotherBookingService.class));
        }
        Assert.assertEquals((int)AnotherBookingService.getInvocationCount(), (int)1);
        this.nameProducer.setName("10001");
        AnotherBookingService instance = (AnotherBookingService)this.anotherBookingService.get();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((int)AnotherBookingService.getInvocationCount(), (int)2);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesDefaultSettingSinceValidatedMethodImplementsAnInterfaceMethod() {
        try {
            this.shipmentService.findShipment(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromSuperTypeMethodIfValidatedMethodImplementsAnInterfaceMethod() {
        try {
            this.shipmentService.getShipment();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromSuperTypeIfValidatedMethodImplementsAnInterfaceMethod() {
        try {
            this.shipmentService.getAnotherShipment();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesDefaultSettingIfValidatedMethodOverridesASuperTypeMethod() {
        try {
            this.shipmentServiceSubClass.findShipment(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromSuperTypeMethodIfValidatedMethodOverridesASuperTypeMethod() {
        try {
            this.shipmentServiceSubClass.getShipment();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromSuperTypeIfValidatedMethodOverridesASuperTypeMethod() {
        try {
            this.shipmentServiceSubClass.getAnotherShipment();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromHighestMethodInHierarchyIfValidatedMethodImplementsAnInterfaceMethod() {
        try {
            this.anotherShipmentService.getShipment();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="h")
    public void testExecutableValidationUsesSettingFromSuperTypeForOverriddenMethodsAndLocalSettingForNonOverriddenMethod() {
        try {
            this.deliveryService.createDelivery(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
        String expressDelivery = this.deliveryService.createExpressDelivery(null);
        Assert.assertNotNull((Object)expressDelivery);
    }
}

