/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import org.eclipse.ease.ui.help.hovers.EditorToolTipGenerator;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;

public class EditorToolTipDecorator
extends ToolTip {
    private Browser fBrowser;
    private Combo fInputCombo;

    public EditorToolTipDecorator(Control control) {
        super(control);
    }

    public void setInputCombo(Combo fInputCombo) {
        this.fInputCombo = fInputCombo;
    }

    public Composite createToolTipContentArea(Event event, Composite parent) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 8;
        gridLayout.marginHeight = 8;
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)gridLayout);
        this.fBrowser = new Browser(composite, 0);
        String toolTipText = EditorToolTipGenerator.getToolTipText(EditorToolTipGenerator.getSelectedToken(this.fInputCombo));
        String theText = "<html>" + toolTipText + "</html>";
        this.fBrowser.setText(theText);
        java.awt.Point location = MouseInfo.getPointerInfo().getLocation();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point relativeLocation = composite.toDisplay((int)location.getX(), (int)location.getY());
        int x = location.x;
        int y = location.y;
        if ((double)(relativeLocation.x + 616) > screenSize.getWidth()) {
            x -= (int)((double)(relativeLocation.x + 616) - screenSize.getWidth());
        }
        if ((double)(relativeLocation.y + 216) > screenSize.getHeight()) {
            y -= (int)((double)(relativeLocation.y + 216) - screenSize.getHeight());
        }
        composite.getShell().setBounds(x, y, 616, 216);
        this.fBrowser.setSize(600, 170);
        if (toolTipText != null) {
            composite.getShell().open();
        }
        composite.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Tracker tracker = new Tracker(composite.getParent(), 16);
                tracker.setStippled(true);
                Rectangle rect = composite.getBounds();
                tracker.setRectangles(new Rectangle[]{rect});
                if (tracker.open()) {
                    Rectangle after = tracker.getRectangles()[0];
                    composite.getShell().setSize(after.width + 20, after.height + 20);
                    EditorToolTipDecorator.this.fBrowser.setSize(after.width + 20 - 16, after.height + 20 - 46);
                }
                tracker.dispose();
            }
        });
        while (!composite.getShell().isDisposed()) {
            if (composite.getShell().getDisplay().readAndDispatch()) continue;
            composite.getShell().getDisplay().sleep();
        }
        composite.getShell().getDisplay().dispose();
        composite.pack();
        return composite;
    }
}

