/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling.editors;

import org.eclipse.ease.modules.modeling.editors.SelectionRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class Editor {
    private static final long serialVersionUID = 2489151579665730844L;
    private final IEditorPart _editor;
    private DocumentRewriteSession _key;

    public String getClassName() {
        return "Editor";
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        return doc;
    }

    public ITextEditor getTextEditor() {
        IEditorPart part = this._editor;
        ITextEditor result = null;
        if (part instanceof ITextEditor) {
            result = (ITextEditor)part;
        }
        return result;
    }

    public Editor(IEditorPart editor) {
        this._editor = editor;
        String[] stringArray = new String[]{"applyEdit", "beginCompoundChange", "close", "endCompoundChange", "getLineAtOffset", "getOffsetAtLine", "save", "selectAndReveal", "toString"};
    }

    public void save() {
        if (this._editor != null) {
            this._editor.doSave(null);
        }
    }

    public void selectAndReveal(final int offset, final int length) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ITextEditor editor = Editor.this.getTextEditor();
                editor.selectAndReveal(offset, length);
            }
        });
    }

    public int getCurrentOffset() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        class ResultRef {
            public int result = -1;

            ResultRef() {
            }
        }
        final ResultRef result = new ResultRef();
        display.syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                ITextSelection ts = (ITextSelection)Editor.this.getTextEditor().getSelectionProvider().getSelection();
                result.result = ts.getOffset();
            }
        });
        return result.result;
    }

    public void setCurrentOffset(int offset) {
        this.getTextEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
    }

    public String getLineDelimiter() {
        String[] delims;
        IDocument document = this.getDocument();
        String result = "\n";
        if (document != null && (delims = document.getLegalLineDelimiters()).length > 0) {
            result = delims[0];
        }
        return result;
    }

    public String getId() {
        String result = "";
        if (this._editor != null) {
            result = this._editor.getSite().getId();
        }
        return result;
    }

    public SelectionRange getSelectionRange() {
        ITextSelection ts = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        return new SelectionRange(ts);
    }

    public String getSource() {
        return this.getDocument().get();
    }

    public int getSourceLength() {
        return this.getDocument().getLength();
    }

    public String getTitle() {
        ITextEditor uniEditor = this.getTextEditor();
        if (uniEditor != null) {
            return uniEditor.getTitle();
        }
        return null;
    }

    public void applyEdit(int offset, int deleteLength, String insertText) {
        IEditorPart part = this._editor;
        if (part != null && part instanceof ITextEditor) {
            IDocument doc = this.getDocument();
            try {
                doc.replace(offset, deleteLength, insertText);
            }
            catch (BadLocationException e) {
                System.err.println("Error: " + (Object)((Object)e));
            }
        }
    }

    public void beginCompoundChange() {
        if (this._key == null) {
            IDocument document = this.getDocument();
            if (document != null) {
                IDocumentExtension4 docExt = (IDocumentExtension4)document;
                this._key = docExt.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
            }
        } else {
            throw new IllegalStateException("A previous begin change was not closed");
        }
    }

    public void close(boolean save) {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            editor.close(save);
        }
    }

    public void endCompoundChange() {
        if (this._key != null) {
            IDocument document = this.getDocument();
            if (document != null) {
                IDocumentExtension4 docExt = (IDocumentExtension4)document;
                docExt.stopRewriteSession(this._key);
            }
            this._key = null;
        }
    }

    public int getLineAtOffset(int offset) {
        try {
            return this.getDocument().getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getOffsetAtLine(final int line) {
        class Result {
            public int result;

            Result() {
            }
        }
        final Result r = new Result();
        r.result = -1;
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    r.result = Editor.this.getDocument().getLineOffset(line);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        return r.result;
    }

    public String toString() {
        return "[object Editor]";
    }
}

