/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.modeling.GMFtoEMFCommandWrapper;
import org.eclipse.ease.modules.modeling.NotationModule;
import org.eclipse.ease.modules.modeling.UMLModule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.OpenDiagramCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.uml.diagram.clazz.ClassDiagramCreationCondition;
import org.eclipse.papyrus.uml.diagram.clazz.CreateClassDiagramCommand;
import org.eclipse.uml2.uml.Element;

public class PapyrusModule
extends UMLModule {
    private final NotationModule notationModule = new NotationModule();

    @WrapToScript
    public ModelSet getModelSet() {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.getModel());
        if (editingDomain == null) {
            Logger.error((String)"org.eclipse.ease.modules.modeling", (String)"Unable to get the editing domain");
            return null;
        }
        ResourceSet resourceSet = editingDomain.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            return (ModelSet)resourceSet;
        }
        Logger.error((String)"org.eclipse.ease.modules.modeling", (String)"The resource set is not a model set");
        return null;
    }

    @Override
    public void initialize(IScriptEngine engine, IEnvironment environment) {
        super.initialize(engine, environment);
        this.notationModule.initialize(engine, environment);
    }

    @WrapToScript
    public View getSelectionView() {
        EObject v = this.notationModule.getSelection();
        if (v instanceof View) {
            return (View)v;
        }
        return null;
    }

    @WrapToScript
    public Element getSelectionElement() {
        EObject elem = this.getSelection();
        if (elem instanceof Element) {
            return (Element)elem;
        }
        return null;
    }

    @WrapToScript
    public void createDiagram(EObject semanticElement, @ScriptParameter(name="diagramType") String diagramType, @ScriptParameter(name="diagramName", defaultValue="NewDiagram") String newDiagram, @ScriptParameter(name="open") boolean open) {
        if ("Class".equals(diagramType)) {
            this.createDiagram(this.getModelSet(), (ICreationCommand)new CreateClassDiagramCommand(), new ClassDiagramCreationCondition(), semanticElement, newDiagram, open);
        }
    }

    @WrapToScript
    public void control(EObject semanticElement, @ScriptParameter(name="fileName") String fileName) {
        if (fileName == null) {
            fileName = semanticElement.eResource().getURIFragment(semanticElement);
        }
        URI baseURI = semanticElement.eResource().getURI();
        URI createURI = baseURI.trimSegments(1).appendSegment(String.valueOf(fileName) + ".uml");
        ControlModeRequest controlRequest = ControlModeRequest.createUIControlModelRequest((TransactionalEditingDomain)this.getEditingDomain(), (EObject)semanticElement, (URI)createURI);
        controlRequest.setIsUIAction(false);
        IControlModeManager controlMng = ControlModeManager.getInstance();
        ICommand controlCommand = controlMng.getControlCommand(controlRequest);
        this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(controlCommand));
    }

    private void createDiagram(ModelSet modelSet, ICreationCommand creationCommand, ClassDiagramCreationCondition creationCondition, EObject target, String diagramName, boolean openDiagram) {
        NavigableElement navElement = this.getNavigableElementWhereToCreateDiagram(creationCondition, target);
        if (navElement != null && modelSet != null) {
            CompositeCommand command = PapyrusModule.getLinkCreateAndOpenNavigableDiagramCommand(navElement, creationCommand, diagramName, modelSet, openDiagram);
            try {
                command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private NavigableElement getNavigableElementWhereToCreateDiagram(ClassDiagramCreationCondition creationCondition, EObject selectedElement) {
        if (selectedElement != null) {
            if (creationCondition.create(selectedElement)) {
                return new ExistingNavigableElement(selectedElement, null);
            }
            List navElements = NavigationHelper.getInstance().getAllNavigableElements(selectedElement);
            Collections.sort(navElements);
            for (NavigableElement navElement : navElements) {
                if (!(navElement instanceof CreatedNavigableElement) || !creationCondition.create(navElement.getElement())) continue;
                return navElement;
            }
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return (TransactionalEditingDomain)super.getEditingDomain();
    }

    public static CompositeCommand getLinkCreateAndOpenNavigableDiagramCommand(final NavigableElement navElement, ICreationCommand creationCommandInterface, String diagramName, ModelSet modelSet, boolean openDiagram) {
        CompositeCommand compositeCommand = new CompositeCommand("Create diagram");
        if (navElement instanceof CreatedNavigableElement) {
            compositeCommand.add((IUndoableOperation)new AbstractTransactionalCommand(modelSet.getTransactionalEditingDomain(), "Create hierarchy", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    NavigationHelper.linkToModel((CreatedNavigableElement)((CreatedNavigableElement)navElement));
                    NavigationHelper.setBaseName((CreatedNavigableElement)((CreatedNavigableElement)navElement), (String)"");
                    return CommandResult.newOKCommandResult();
                }
            });
        }
        ICommand createDiagCommand = creationCommandInterface.getCreateDiagramCommand(modelSet, navElement.getElement(), diagramName);
        compositeCommand.add((IUndoableOperation)createDiagCommand);
        if (openDiagram) {
            compositeCommand.add((IUndoableOperation)new OpenDiagramCommand(modelSet.getTransactionalEditingDomain(), createDiagCommand));
        }
        return compositeCommand;
    }

    @Override
    @WrapToScript
    public boolean eInstanceOf(@ScriptParameter(name="eObject") EObject eObject, @ScriptParameter(name="type") String type) {
        EClassifier classifier = this.getEPackage().getEClassifier(type);
        if (classifier == null) {
            classifier = this.notationModule.getEPackage().getEClassifier(type);
        }
        return classifier.isInstance((Object)eObject);
    }

    @Override
    @WrapToScript
    public void save(@ScriptParameter(name="object", defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object object) {
        this.save();
    }
}

