/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling.ui.matchers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.ease.modules.modeling.ui.Messages;
import org.eclipse.ease.modules.modeling.ui.exceptions.MatcherException;
import org.eclipse.ease.modules.modeling.ui.matchers.IMatcher;
import org.eclipse.ease.modules.modeling.ui.utils.ModelExtentMap;
import org.eclipse.ease.modules.modeling.ui.utils.SelectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.OCLHelper;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.SetValue;

public class OCLMatcher
implements IMatcher {
    @Override
    public Collection<EObject> getElements(String oclString, IEditingDomainProvider currentEditor) throws MatcherException {
        EObject root = SelectionUtils.getSelection(currentEditor);
        OCL ocl = OCL.newInstance((EPackage.Registry)EPackage.Registry.INSTANCE);
        ocl.setModelManager((ModelManager)new ModelExtentMap(ocl.getMetamodelManager(), root));
        OCLHelper helper = ocl.createOCLHelper((EObject)root.eClass());
        try {
            ExpressionInOCL query = helper.createQuery(oclString);
            Object queryResult = ocl.evaluate((Object)root, query);
            if (queryResult instanceof SetValue) {
                return ((SetValue)queryResult).asCollection();
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new MatcherException(Messages.OCLMatcher_CONSTRAINT_INVALID);
        }
        return Collections.emptyList();
    }

    @Override
    public String getText() {
        return Messages.OCLMatcher_COMBO_TEXT_OCL;
    }

    @Override
    public String getHelp() {
        return Messages.OCLMatcher_HELP_OCL;
    }
}

