/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.ease.ui.tools.DecoratedLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;

public class ModulesDecoratedLabelProvider
extends DecoratedLabelProvider {
    private final StyledString.Styler fStrikeThroughStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    };

    public ModulesDecoratedLabelProvider(ILabelProvider commonLabelProvider) {
        super(commonLabelProvider);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IPath) {
            return null;
        }
        if (element instanceof ModuleDefinition) {
            return ((ModuleDefinition)element).getBundleID();
        }
        if (element instanceof Method) {
            return ModulesTools.getSignature((Method)element, true);
        }
        return null;
    }

    protected StyledString getStyledText(Object element) {
        StyledString base = super.getStyledText(element);
        if (element instanceof AccessibleObject && ModulesDecoratedLabelProvider.isDeprecated((AccessibleObject)element)) {
            base.setStyle(0, base.length(), this.fStrikeThroughStyler);
        } else if (element instanceof ModuleDefinition && ((ModuleDefinition)element).getModuleClass().getAnnotation(Deprecated.class) != null) {
            base.setStyle(0, base.length(), this.fStrikeThroughStyler);
        }
        return base;
    }

    private static boolean isDeprecated(AccessibleObject element) {
        return element.getAnnotation(Deprecated.class) != null;
    }
}

