/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class JavaResources {
    private static final JavaResources INSTANCE = new JavaResources();
    private static final String PLUGIN_ID = "org.eclipse.ease.ui.completions.java";
    private static final Pattern FQN_CLASSNAME_PATTERN = Pattern.compile("(\\p{Lower}+(?:\\.\\p{Lower}+)*)\\.(\\p{Upper}.*)");
    private static final Collection<String> FILTERED_PACKAGES = Arrays.asList("java.awt", "java.applet", "groovy", "netscape", "kotlin");
    private Map<String, Collection<String>> fPackagesAndClasses = Collections.emptyMap();
    private boolean fisLoadingTriggered = false;

    public static JavaResources getInstance() {
        return INSTANCE;
    }

    private JavaResources() {
    }

    public Map<String, Collection<String>> getClasses() {
        if (this.fPackagesAndClasses.isEmpty()) {
            this.loadClasses();
        }
        return this.fPackagesAndClasses;
    }

    public Collection<String> getPackages() {
        return this.getClasses().keySet();
    }

    public Collection<String> getClasses(String packageName) {
        if (this.getClasses().containsKey(packageName)) {
            return this.getClasses().get(packageName);
        }
        return Collections.emptySet();
    }

    private void loadClasses() {
        if (!this.fisLoadingTriggered) {
            this.fisLoadingTriggered = true;
            Job job = new Job("Load Java code completion"){

                protected IStatus run(IProgressMonitor monitor) {
                    TreeMap loadingContent = new TreeMap();
                    JavaResources.this.readJavaPackagesAndClasses(loadingContent);
                    JavaResources.this.readEclipsePackages(loadingContent);
                    JavaResources.this.fPackagesAndClasses = loadingContent;
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void readEclipsePackages(Map<String, Collection<String>> target) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            for (String packageName : this.getExportedPackages(bundle)) {
                if (this.isFiltered(packageName)) continue;
                this.registerPackage(target, packageName);
            }
            ++n2;
        }
    }

    private void readJavaPackagesAndClasses(Map<String, Collection<String>> target) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = this.getJavaClassDefinitions();){
                String entry = reader.readLine();
                while (entry != null) {
                    Matcher matcher = FQN_CLASSNAME_PATTERN.matcher(entry);
                    if (matcher.matches()) {
                        this.registerClass(target, matcher.group(1), matcher.group(2));
                    }
                    entry = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.error((String)PLUGIN_ID, (String)"Cannot read package list for code completion", (Throwable)e);
        }
    }

    private void registerPackage(Map<String, Collection<String>> target, String packageName) {
        int delimiterPosition;
        if (!target.containsKey(packageName)) {
            target.put(packageName, new TreeSet());
        }
        if ((delimiterPosition = packageName.lastIndexOf(46)) > 0) {
            this.registerPackage(target, packageName.substring(0, delimiterPosition));
        }
    }

    private void registerClass(Map<String, Collection<String>> target, String packageName, String className) {
        if (!this.isFiltered(packageName)) {
            this.registerPackage(target, packageName);
            target.get(packageName).add(className);
        }
    }

    private boolean isFiltered(String packageName) {
        for (String filter : FILTERED_PACKAGES) {
            if (!packageName.startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    private BufferedReader getJavaClassDefinitions() throws IOException {
        URL url = new URL("platform:/plugin/org.eclipse.ease.ui.completions.java/resources/java" + this.getJavaMajorVersion() + " classes.txt");
        return new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
    }

    private int getJavaMajorVersion() {
        String version;
        int result = 1000;
        Pattern versionPattern = Pattern.compile("(?:1\\.)?(\\d+).*");
        Matcher matcher = versionPattern.matcher(version = System.getProperty("java.runtime.version"));
        if (matcher.matches()) {
            result = Integer.parseInt(matcher.group(1));
        }
        return Math.min(result, 12);
    }

    private Collection<String> getExportedPackages(Bundle bundle) {
        HashSet<String> exportedPackages = new HashSet<String>();
        String exportPackage = (String)bundle.getHeaders().get("Export-Package");
        if (exportPackage != null) {
            String[] packages;
            String[] stringArray = packages = exportPackage.split(",");
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String packageEntry = stringArray[n2];
                String candidate = packageEntry.trim().split(";")[0];
                if (candidate.endsWith("\"")) {
                    candidate = candidate.substring(0, candidate.length() - 1);
                }
                if (!(candidate.contains(".internal") || packageEntry.contains(";x-internal:=true") || candidate.startsWith("Lib") || candidate.startsWith("about_files") || candidate.startsWith("META"))) {
                    exportedPackages.add(candidate);
                }
                ++n2;
            }
        }
        return exportedPackages;
    }
}

