/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completions.java.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;
import org.eclipse.ease.ui.completion.tokenizer.TokenList;
import org.eclipse.ease.ui.completions.java.help.handlers.JavaPackageHelpResolver;
import org.eclipse.ease.ui.completions.java.provider.JavaMethodCompletionProvider;
import org.eclipse.ease.ui.completions.java.provider.JavaResources;

public class JavaPackagesCompletionProvider
extends AbstractCompletionProvider {
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && !this.isCallChain(context) && !this.isJavaClassContext(context) && !this.isStringLiteral(context);
    }

    private boolean isJavaClassContext(ICompletionContext context) {
        TokenList tokens = new TokenList(context.getTokens()).getFromLast(Class.class);
        if (!tokens.isEmpty()) {
            tokens.remove(0);
            tokens.removeIfMatches(0, "()");
            tokens.removeIfMatches(0, ".");
            return tokens.isEmpty() || tokens.size() == 1 && !InputTokenizer.isDelimiter((Object)tokens.get(0));
        }
        tokens = new TokenList(context.getTokens()).getFromLast(Method.class);
        if (!tokens.isEmpty()) {
            tokens.remove(0);
            tokens.removeIfMatches(0, "()");
            tokens.removeIfMatches(0, ".");
            return tokens.isEmpty() || tokens.size() == 1 && !InputTokenizer.isDelimiter((Object)tokens.get(0));
        }
        return false;
    }

    private boolean isCallChain(ICompletionContext context) {
        TokenList tokens = new TokenList(context.getTokens()).getFromLast("()");
        return !tokens.isEmpty() && tokens.getFromLast("(").isEmpty();
    }

    protected void prepareProposals(ICompletionContext context) {
        String packageFilter = this.getFilter(context);
        for (String candidate : JavaResources.getInstance().getPackages()) {
            if (!this.isValidCandidate(candidate, packageFilter)) continue;
            this.addProposal(candidate, String.valueOf(candidate.substring(packageFilter.length() - context.getFilter().length())) + ".", (IImageResolver)new JavaMethodCompletionProvider.JDTImageResolver("org.eclipse.jdt.ui.package_obj.gif"), 60, new JavaPackageHelpResolver(candidate));
        }
    }

    private boolean isValidCandidate(String candidate, String packageFilter) {
        if (candidate.startsWith(packageFilter)) {
            return !candidate.substring(packageFilter.length()).contains(".");
        }
        return false;
    }

    private String getFilter(ICompletionContext context) {
        StringBuilder filter = new StringBuilder();
        ArrayList reversedTokens = new ArrayList(context.getTokens());
        Collections.reverse(reversedTokens);
        for (Object token : reversedTokens) {
            if (token instanceof Package) {
                filter.insert(0, ((Package)token).getName());
                break;
            }
            if (InputTokenizer.isDelimiter(token) && !".".equals(token) || !(token instanceof String)) break;
            filter.insert(0, token);
        }
        return filter.toString();
    }
}

