/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.internal.ui.wizards.DriverUIContributorComposite;
import org.eclipse.datatools.connectivity.sqm.core.SQMServices;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.ExtensibleNewConnectionProfileWizard;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExtensibleProfileDetailsWizardPage
extends ConnectionProfileDetailsPage
implements IDriverUIContributorInformation {
    private String driverCategoryID = "";
    private DriverListCombo driverCombo = null;
    private DriverUIContributorComposite contributedUIComposite = null;
    private Properties properties = null;

    public ExtensibleProfileDetailsWizardPage(String wizardPageName) {
        super(wizardPageName);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.description"));
    }

    public ExtensibleProfileDetailsWizardPage(String wizardPageName, String driverCategoryID) {
        super(wizardPageName);
        this.driverCategoryID = driverCategoryID;
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.description"));
    }

    public void createCustomControl(Composite parent) {
        IWizard wiz = this.getWizard();
        if (wiz instanceof ExtensibleNewConnectionProfileWizard) {
            ExtensibleNewConnectionProfileWizard wizard = (ExtensibleNewConnectionProfileWizard)wiz;
            String tempDriverCategoryID = SQMServices.getProviderIDMappingRegistry().getCategoryIDforProviderID(wizard.getProfileProviderID());
            if (tempDriverCategoryID != null && tempDriverCategoryID.trim().length() > 0) {
                this.driverCategoryID = tempDriverCategoryID;
            }
        }
        parent.setLayout((Layout)new GridLayout());
        this.driverCombo = new DriverListCombo();
        this.driverCombo.setLabelText(ConnectivityUIPlugin.getDefault().getResourceString("ExtensibleProfileDetailsWizardPage.driverCombo.label"));
        this.driverCombo.setCategory(this.driverCategoryID);
        this.driverCombo.setNullDriverIsValid(false);
        this.driverCombo.createContents(parent);
        this.contributedUIComposite = new DriverUIContributorComposite(parent, (DialogPage)this, this, false);
        this.driverCombo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExtensibleProfileDetailsWizardPage.this.handleDriverComboSelectionChangeEvent(e);
            }
        });
        if (this.driverCombo.getCombo().getItemCount() > 0) {
            this.driverCombo.getCombo().select(0);
        } else if (this.driverCombo.getErrorMessage() != null) {
            this.setMessage(this.driverCombo.getErrorMessage(), 1);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"GENERIC_DB_PROFILE_WIZARD_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private void handleDriverComboSelectionChangeEvent(ChangeEvent e) {
        if (this.driverCombo.getErrorMessage() != null) {
            this.setErrorMessage(this.driverCombo.getErrorMessage());
        } else {
            this.setMessage(null);
        }
        if (this.driverCombo.getSelectedDriverInstance() != null) {
            this.properties = this.copyProperties(this.driverCombo.getSelectedDriverInstance().getPropertySet().getBaseProperties());
            this.properties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", this.driverCombo.getSelectedDriverID());
        }
        this.contributedUIComposite.setDriverTemplateID(this.driverCombo.getSelectedDriverID());
    }

    public boolean determinePageCompletion() {
        boolean isComplete;
        boolean bl = isComplete = this.contributedUIComposite != null && this.contributedUIComposite.determineContributorCompletion();
        if (isComplete) {
            this.setErrorMessage(null);
        }
        this.setPingButtonEnabled(isComplete);
        this.setPageComplete(isComplete);
        return isComplete;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setPageComplete(this.determinePageCompletion());
    }

    public List getSummaryData() {
        List summaryData = new ArrayList();
        summaryData = this.contributedUIComposite.getSummaryData();
        return summaryData;
    }

    private Properties copyProperties(Properties properties) {
        Properties copy = new Properties();
        Enumeration<Object> propertyKeys = properties.keys();
        while (propertyKeys.hasMoreElements()) {
            Object key = propertyKeys.nextElement();
            copy.put(key, properties.get(key));
        }
        return copy;
    }

    public boolean isPageComplete() {
        if (this.driverCombo == null) {
            return false;
        }
        if (this.driverCombo != null && this.driverCombo.getSelectedDriverID() == null) {
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return super.isPageComplete();
    }

    public void dispose() {
        if (this.driverCombo != null) {
            this.driverCombo.dispose();
        }
        super.dispose();
    }
}

