/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultConfiguration;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstanceFactory;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.SerializationHelper;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;

public class ResultsViewAPI {
    private static ResultsViewAPI _instance;
    private static ILogger _log;
    private IResultManager _manager = ResultsViewPlugin.getDefault().getResultManager();

    static {
        _log = ResultsViewPlugin.getLogger(null);
    }

    public static synchronized ResultsViewAPI getInstance() {
        if (_instance == null) {
            _instance = new ResultsViewAPI();
        }
        return _instance;
    }

    private ResultsViewAPI() {
    }

    public IResultManager getResultManager() {
        return this._manager;
    }

    public int getCurrentStatus(OperationCommand cmd) {
        if (cmd == null) {
            return -1;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            return instance.getStatus();
        }
        return -1;
    }

    public Throwable[] getFailThrowables(OperationCommand cmd, boolean includeSubThrowables) {
        if (cmd == null) {
            return null;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            Throwable[] parentErrors = instance.getFailThrowables();
            int i = 0;
            while (i < parentErrors.length) {
                if (parentErrors[i] != null) {
                    errors.add(parentErrors[i]);
                }
                ++i;
            }
            if (!includeSubThrowables) {
                return errors.toArray(new Throwable[errors.size()]);
            }
            for (IResultInstance subIns : instance.getSubResults()) {
                OperationCommand subCmd = subIns.getOperationCommand();
                Throwable[] subErrors = this.getFailThrowables(subCmd, true);
                if (subErrors == null) continue;
                int i2 = 0;
                while (i2 < subErrors.length) {
                    if (subErrors[i2] != null) {
                        errors.add(subErrors[i2]);
                    }
                    ++i2;
                }
            }
            return errors.toArray(new Throwable[errors.size()]);
        }
        return null;
    }

    public Throwable[] getFailThrowables(OperationCommand cmd) {
        return this.getFailThrowables(cmd, false);
    }

    public boolean appendThrowable(OperationCommand cmd, Throwable th) {
        if (cmd == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.moreThrowable(th);
            return true;
        }
        return false;
    }

    public boolean appendPlainMessage(OperationCommand cmd, String message) {
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.morePlainMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendResultSet(OperationCommand cmd, IResultSetObject rs) {
        block4: {
            IResultInstance instance;
            block5: {
                if (cmd == null || rs == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    if (instance == null) break block4;
                    if (!instance.isFinished()) break block5;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean appendResultSet(OperationCommand cmd, ResultSet rs) {
        block4: {
            IResultInstance instance;
            block5: {
                if (cmd == null || rs == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    if (instance == null) break block4;
                    if (!instance.isFinished()) break block5;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean appendStatusMessage(OperationCommand cmd, String message) {
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.moreStatusMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendUpdateCountMessage(OperationCommand cmd, int count) {
        if (cmd == null || count < 0) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.moreUpdateCount(count);
            return true;
        }
        return false;
    }

    public boolean appendXMLResultSet(OperationCommand cmd, String xmlString) {
        block6: {
            XMLResultSetObject rs;
            IResultInstance instance;
            block7: {
                if (cmd == null || xmlString == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
                }
                catch (Exception dex) {
                    _log.error("ResultsViewAPI_notwellformed_xml", (Throwable)dex);
                    return false;
                }
                try {
                    rs = new XMLResultSetObject(xmlString);
                    if (instance == null) break block6;
                    if (!instance.isFinished()) break block7;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean createNewInstance(OperationCommand cmd, Runnable terminateHandler) {
        IResultInstance instance = ResultInstanceFactory.INSTANCE.createNewInstance(cmd, terminateHandler);
        return instance != null;
    }

    public IResultInstance getResultInstance(OperationCommand cmd) {
        return this._manager.getInstance(cmd);
    }

    public boolean showParameters(OperationCommand cmd, List params) {
        if (cmd == null || params == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.showParameters(params);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(OperationCommand cmd, int status) {
        OperationCommand operationCommand = cmd;
        synchronized (operationCommand) {
            block8: {
                IResultInstance instance;
                block10: {
                    block9: {
                        block7: {
                            if (cmd != null && status >= 1 && status <= 7) break block7;
                            return false;
                        }
                        instance = this._manager.getInstance(cmd);
                        if (instance == null) break block8;
                        if (!instance.isFinished()) break block9;
                        return false;
                    }
                    if (instance.getStatus() != 2 || status != 1) break block10;
                    return false;
                }
                instance.updateStatus(status);
                return true;
            }
            return false;
        }
    }

    public boolean createSubInstance(OperationCommand parentCmd, OperationCommand cmd, Runnable terminateHandler) {
        if (cmd == null || parentCmd == null) {
            return false;
        }
        IResultInstance parentResult = this._manager.getInstance(parentCmd);
        if (parentResult != null && !parentResult.isFinished()) {
            parentResult.createSubResult(cmd, terminateHandler);
            return true;
        }
        return false;
    }

    public OperationCommand getSubOperationCommand(OperationCommand parentCmd, int subNum) {
        if (parentCmd == null) {
            return null;
        }
        IResultInstance parentResult = this._manager.getInstance(parentCmd);
        if (parentResult != null) {
            if (subNum > parentResult.getSubResults().size() - 1) {
                return null;
            }
            return ((IResultInstance)parentResult.getSubResults().get(subNum)).getOperationCommand();
        }
        return null;
    }

    public int calculateStatus(OperationCommand command) {
        if (command == null) {
            return 6;
        }
        IResultInstance result = this._manager.getInstance(command);
        if (result != null) {
            return result.calculateStatus();
        }
        return 6;
    }

    public int getMaxRowPreference() {
        return ResultConfiguration.getInstance().getMaxRowCount();
    }

    public int getMaxRowDisplayPreference() {
        return ResultConfiguration.getInstance().getMaxDisplayRowCount();
    }

    public boolean getShowLabelPreference() {
        return ResultConfiguration.getInstance().isShowLabel();
    }

    public void saveDetailResults(OperationCommand operationCommand) {
        if (!ResultConfiguration.getInstance().isAutoSave()) {
            return;
        }
        IResultInstance ri = ResultsViewPlugin.getDefault().getResultManager().getInstance(operationCommand);
        if (ri instanceof ResultInstance) {
            Object[] objs = new Object[]{ri.getParameters(), ((ResultInstance)ri).getResults()};
            SerializationHelper.SaveObjects(objs, ((ResultInstance)ri).getFileName());
        }
    }

    public void saveParentDetailResults(OperationCommand operationCommand) {
        if (!ResultConfiguration.getInstance().isAutoSave()) {
            return;
        }
        IResultInstance ri = ResultsViewPlugin.getDefault().getResultManager().getInstance(operationCommand);
        if (ri != null && ri.getSubResults() != null && ri.getSubResults().size() > 0) {
            this.saveDetailResults(operationCommand);
        }
    }

    public void saveElapseTime(OperationCommand operationCommand, long elapsedTime) {
        IResultInstance ri = ResultsViewPlugin.getDefault().getResultManager().getInstance(operationCommand);
        if (ri instanceof ResultInstance) {
            if (!ri.isParentResult() || ri.getSubResults().size() == 0) {
                ((ResultInstance)ri).setElapsedTime(elapsedTime);
            }
            this.appendStatusMessage(operationCommand, this.countTime(elapsedTime));
        }
    }

    public void saveParentElapseTime(OperationCommand operationCommand) {
        IResultInstance ri = ResultsViewPlugin.getDefault().getResultManager().getInstance(operationCommand);
        if (!ri.isParentResult() || ri.getSubResults().size() == 0) {
            return;
        }
        if (ri instanceof ResultInstance) {
            long totalTime = 0L;
            for (Object obj : ri.getSubResults()) {
                if (!(obj instanceof ResultInstance)) continue;
                totalTime += ((ResultInstance)obj).getElapsedTime();
            }
            ((ResultInstance)ri).setElapsedTime(totalTime);
            this.appendStatusMessage(operationCommand, this.countTime(totalTime));
        }
    }

    private String countTime(long elapsedTime) {
        long ms = elapsedTime % 1000L;
        long sec = elapsedTime / 1000L % 60L;
        long min = elapsedTime / 60000L % 60L;
        long hr = elapsedTime / 3600000L % 60L;
        return new MessageFormat(String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator") + Messages.ResultSection_Status_ElapsedTime).format(new Object[]{hr, min, sec, ms});
    }
}

