/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResourceIdentifiers {
    public static final String ODA_APP_CONTEXT_KEY_CONSUMER_RESOURCE_IDS = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
    private static final String APPL_RESOURCE_TYPE = "ApplResourceType";
    private static final String DESIGN_RESOURCE_TYPE = "DesignResourceType";
    private static final String EMPTY_STRING = "";
    private static String sm_loggerName = ResourceIdentifiers.class.getName();
    private static Logger sm_logger = Logger.getLogger(sm_loggerName);
    private HashMap<String, URILocator> m_uriLocators = new HashMap(2);

    public static ResourceIdentifiers get(Object appContext) {
        if (!(appContext instanceof Map)) {
            return null;
        }
        Object mapValue = ((Map)appContext).get(ODA_APP_CONTEXT_KEY_CONSUMER_RESOURCE_IDS);
        return mapValue instanceof ResourceIdentifiers ? (ResourceIdentifiers)mapValue : null;
    }

    public static URI resolveApplResource(Object instance, URI uri) {
        if (instance == null) {
            return null;
        }
        URI resolvedFilePathURI = instance instanceof ResourceIdentifiers ? ((ResourceIdentifiers)instance).resolveApplResource(uri) : ReflectionHelper.invokeResolveMethod(instance, "resolveApplResource", uri);
        return resolvedFilePathURI;
    }

    public static URI getApplResourceBaseURI(Object instance) {
        if (instance == null) {
            return null;
        }
        URI resourceBaseURI = instance instanceof ResourceIdentifiers ? ((ResourceIdentifiers)instance).getApplResourceBaseURI() : ReflectionHelper.invokeGetURIMethod(instance, "getApplResourceBaseURI");
        return resourceBaseURI;
    }

    public URI resolveApplResource(URI uri) {
        return this.resolveResourceURI(APPL_RESOURCE_TYPE, uri);
    }

    public URI getApplResourceBaseURI() {
        return this.getResourceBaseURI(APPL_RESOURCE_TYPE);
    }

    public void setApplResourceBaseURI(URI baseURI) {
        this.setResourceBaseURI(APPL_RESOURCE_TYPE, baseURI);
    }

    public URILocator getApplResourceURILocator() {
        return this.getResourceURILocator(APPL_RESOURCE_TYPE);
    }

    public void registerApplResourceURILocator(URILocator uriLocator) {
        this.registerResourceURILocator(APPL_RESOURCE_TYPE, uriLocator);
    }

    public static URI resolveDesignResource(Object instance, URI uri) {
        if (instance == null) {
            return null;
        }
        URI resolvedFilePathURI = instance instanceof ResourceIdentifiers ? ((ResourceIdentifiers)instance).resolveDesignResource(uri) : ReflectionHelper.invokeResolveMethod(instance, "resolveDesignResource", uri);
        return resolvedFilePathURI;
    }

    public static URI getDesignResourceBaseURI(Object instance) {
        if (instance == null) {
            return null;
        }
        URI resourceBaseURI = instance instanceof ResourceIdentifiers ? ((ResourceIdentifiers)instance).getDesignResourceBaseURI() : ReflectionHelper.invokeGetURIMethod(instance, "getDesignResourceBaseURI");
        return resourceBaseURI;
    }

    public URI resolveDesignResource(URI uri) {
        return this.resolveResourceURI(DESIGN_RESOURCE_TYPE, uri);
    }

    public URI getDesignResourceBaseURI() {
        return this.getResourceBaseURI(DESIGN_RESOURCE_TYPE);
    }

    public void setDesignResourceBaseURI(URI baseURI) {
        this.setResourceBaseURI(DESIGN_RESOURCE_TYPE, baseURI);
    }

    public URILocator getDesignResourceURILocator() {
        return this.getResourceURILocator(DESIGN_RESOURCE_TYPE);
    }

    public void registerDesignResourceURILocator(URILocator uriLocator) {
        this.registerResourceURILocator(DESIGN_RESOURCE_TYPE, uriLocator);
    }

    private URI getResourceBaseURI(String resourceType) {
        URILocator locator = this.getResourceURILocator(resourceType);
        return locator != null ? locator.getBaseURI() : null;
    }

    private void setResourceBaseURI(String resourceType, URI baseURI) {
        URILocator locator = this.createURILocator(baseURI);
        this.registerResourceURILocator(resourceType, locator);
    }

    private URI resolveResourceURI(String resourceType, URI uri) {
        URILocator locator = this.getResourceURILocator(resourceType);
        return locator != null ? locator.resolve(uri) : uri;
    }

    private URILocator getResourceURILocator(String resourceType) {
        return this.m_uriLocators.get(resourceType);
    }

    private void registerResourceURILocator(String resourceType, URILocator uriLocator) {
        this.m_uriLocators.put(resourceType, uriLocator);
    }

    protected URILocator createURILocator(URI baseURI) {
        return new URILocator(baseURI);
    }

    public URI resolveResourceLocation(String resourcePath) {
        URILocator locator = this.getApplResourceURILocator();
        if (locator == null) {
            locator = this.getDesignResourceURILocator();
        }
        return locator != null ? locator.resolve(resourcePath) : null;
    }

    public static URI encodeToURI(String filePath) {
        try {
            String encodedLocation = new File(filePath).toURI().toASCIIString();
            String target = new File(EMPTY_STRING).toURI().toASCIIString();
            encodedLocation = encodedLocation.replace(target, EMPTY_STRING);
            return new URI(encodedLocation);
        }
        catch (Exception ex) {
            sm_logger.info("encodeToURI(String): " + ex.toString());
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReflectionHelper {
        private ReflectionHelper() {
        }

        private static URI invokeResolveMethod(Object instance, String methodName, URI argValue) {
            Method resolveMethod = ReflectionHelper.getMethod(instance, methodName, URI.class);
            if (resolveMethod != null) {
                Object returnValue = null;
                try {
                    returnValue = ReflectionHelper.invokeMethod(instance, resolveMethod, argValue);
                    if (returnValue instanceof URI) {
                        return (URI)returnValue;
                    }
                }
                catch (OdaException ex) {
                    sm_logger.fine("Unable to invoke method (" + methodName + ") on the specified ResourceIdentifiers instance: " + ex.getMessage());
                }
            }
            return null;
        }

        private static URI invokeGetURIMethod(Object instance, String methodName) {
            Method resolveMethod = ReflectionHelper.getMethod(instance, methodName, null);
            if (resolveMethod != null) {
                Object returnValue = null;
                try {
                    returnValue = ReflectionHelper.invokeMethod(instance, resolveMethod, null);
                    if (returnValue instanceof URI) {
                        return (URI)returnValue;
                    }
                }
                catch (OdaException ex) {
                    sm_logger.fine("Unable to invoke method (" + methodName + ") on the specified ResourceIdentifiers instance: " + ex.getMessage());
                }
            }
            return null;
        }

        private static Method getMethod(Object instance, String methodName, Class<?> argClazz) {
            if (instance == null) {
                return null;
            }
            try {
                if (argClazz == null) {
                    return instance.getClass().getMethod(methodName, new Class[0]);
                }
                return instance.getClass().getMethod(methodName, argClazz);
            }
            catch (SecurityException ex) {
                sm_logger.fine("Unable to get method (" + methodName + ") from the specified ResourceIdentifiers instance: " + ex.getMessage());
            }
            catch (NoSuchMethodException ex) {
                sm_logger.fine("Unable to get method (" + methodName + ") from the specified ResourceIdentifiers instance: " + ex.getMessage());
            }
            return null;
        }

        private static Object invokeMethod(Object instance, Method method, Object argValue) throws OdaException {
            if (instance == null || method == null) {
                throw new OdaException(new IllegalArgumentException("Null"));
            }
            try {
                if (argValue == null) {
                    return method.invoke(instance, new Object[0]);
                }
                return method.invoke(instance, argValue);
            }
            catch (IllegalArgumentException ex) {
                throw new OdaException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new OdaException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new OdaException(ex);
            }
        }
    }

    public class URILocator {
        private URI m_baseURI;

        public URILocator(URI baseURI) {
            this.m_baseURI = baseURI;
        }

        public URI getBaseURI() {
            return this.m_baseURI;
        }

        public URI resolve(URI uri) {
            return this.resolveImpl(uri);
        }

        public URI resolve(String str) {
            URI uri = ResourceIdentifiers.encodeToURI(str);
            return this.resolve(uri);
        }

        protected URI resolveImpl(URI uri) {
            if (this.m_baseURI == null || uri == null) {
                return uri;
            }
            return this.m_baseURI.resolve(uri);
        }
    }
}

