/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.with;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BaseWindow;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WithTableViewer
extends BaseWindow {
    Text tableName;
    Text columnName;
    Button add;
    Button remove;
    List columnList;
    QuerySelectStatement withStatement;
    WithTableSpecification withTable;
    int fieldWidth = 60;
    int mleHeight = 60;

    public WithTableViewer(SQLDomainModel domain) {
        super(domain);
    }

    public Control createControl(Composite parent) {
        this.client = ViewUtility.createComposite(parent, 1);
        Group tGrp = ViewUtility.createGroup(this.client, 1, Messages._UI_GROUP_WITH_TABLE, false);
        this.tableName = ViewUtility.createTextField((Composite)tGrp, this.fieldWidth);
        Group group = ViewUtility.createGroup(this.client, 3, Messages._UI_GROUP_WITH_COLUMN, true);
        this.columnName = ViewUtility.createTextField((Composite)group, this.fieldWidth);
        GridData data = (GridData)this.columnName.getLayoutData();
        data.verticalAlignment = 1;
        this.columnName.setData((Object)data);
        Composite group2 = ViewUtility.createComposite((Composite)group, 1);
        this.add = ViewUtility.createPushButton(group2, Messages._UI_BUTTON_ADD_RIGHT);
        this.remove = ViewUtility.createPushButton(group2, Messages._UI_BUTTON_REMOVE_LEFT);
        this.columnList = new List((Composite)group, 2820);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.columnList.setLayoutData((Object)data);
        this.tableName.addListener(24, (Listener)this);
        this.columnName.addListener(24, (Listener)this);
        this.columnList.addListener(13, (Listener)this);
        this.add.addListener(13, (Listener)this);
        this.remove.addListener(13, (Listener)this);
        return this.client;
    }

    public void setInput(Object element) {
        super.setInput(element);
        if (element instanceof WithTableSpecification) {
            this.withTable = (WithTableSpecification)element;
            this.withStatement = this.withTable.getQueryExpressionRoot().getSelectStatement();
            this.initializeFields();
        }
    }

    private void initializeFields() {
        this.tableName.removeListener(24, (Listener)this);
        if (this.withTable.getName() != null) {
            this.tableName.setText(this.withTable.getName());
        } else {
            this.tableName.setText("");
        }
        this.columnName.setText("");
        Iterator iterator = this.withTable.getColumnNameList().iterator();
        this.columnList.removeAll();
        while (iterator.hasNext()) {
            ColumnName cn = (ColumnName)iterator.next();
            this.columnList.add(cn.getName());
        }
        this.tableName.addListener(24, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.add && this.columnName.getText().trim().length() > 0) {
            this.columnList.add(this.columnName.getText());
            ColumnName newCN = StatementHelper.createColumnName((String)this.columnName.getText());
            this.withTable.getColumnNameList().add((Object)newCN);
            this.columnName.setText("");
        }
        if (event.widget == this.remove) {
            int index = this.columnList.getSelectionIndex();
            if (index < 0) {
                return;
            }
            EList columns = this.withTable.getColumnNameList();
            if (index < columns.size()) {
                this.columnList.remove(index);
                this.withTable.getColumnNameList().remove(index);
            }
        }
        if (event.widget == this.tableName) {
            this.withTable.setName(this.tableName.getText());
        }
        SelectHelper.refresh(this.withTable.getQueryExpressionRoot().getSelectStatement());
    }
}

