/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.actions;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.Images;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.texteditor.IUpdate;

public class RemoveResultAction
extends BaseSelectionListenerAction
implements IUpdate {
    ISelectionProvider _provider;

    public RemoveResultAction(ISelectionProvider provider) {
        super(Messages.RemoveResultAction_remove);
        this.setImageDescriptor(Images.DESC_REMOVE);
        this.setDisabledImageDescriptor(Images.DESC_REMOVE_DISABLE);
        this.setToolTipText(Messages.RemoveResultAction_remove_result);
        this._provider = provider;
        this._provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setEnabled(this.updateSelection((IStructuredSelection)this._provider.getSelection()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"action_remove_result", (String)ResultsViewUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void dispose() {
        this._provider.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0) {
            return false;
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof IResultInstance) {
                if (!((IResultInstance)obj[i]).isFinished()) {
                    return false;
                }
                if (!((IResultInstance)obj[i]).isParentResult()) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        IResultInstance[] instances;
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel == null) {
            return;
        }
        Object[] objs = sel.toArray();
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof IResultInstance) {
                    ResultsViewUIPlugin.getResultManager().removeResultInstance((IResultInstance)objs[i]);
                }
                ++i;
            }
        }
        if ((instances = ResultsViewUIPlugin.getResultManager().getAllResults()).length > 0) {
            this._provider.setSelection((ISelection)new StructuredSelection((Object)instances[0]));
        }
    }

    public void update() {
        this.setEnabled(this.updateSelection(this.getStructuredSelection()));
    }
}

