# frozen_string_literal: true

class PrepareIndexOnVulnerabilityOccurrencesUuidIncludingVulnerabilityIdAsync < Gitlab::Database::Migration[2.1]
  INDEX_NAME = "index_vuln_findings_on_uuid_including_vuln_id_1"

  def up
    index_sql = <<~SQL
      CREATE UNIQUE INDEX CONCURRENTLY #{INDEX_NAME}
      ON vulnerability_occurrences(uuid_convert_string_to_uuid)
      INCLUDE(vulnerability_id)
    SQL

    prepare_async_index_from_sql(index_sql)
  end

  def down
    unprepare_async_index_by_name(
      :vulnerability_occurrences,
      INDEX_NAME
    )
  end
end
