# frozen_string_literal: true

class AddHasMergeRequestToVulnerabilityReads < Gitlab::Database::Migration[2.1]
  enable_lock_retries!

  def up
    add_column :vulnerability_reads, :has_merge_request, :boolean, default: false, if_not_exists: true
  end

  def down
    remove_column :vulnerability_reads, :has_merge_request, if_exists: true
  end
end
