---
stage: Monitor
group: Respond
description: Error tracking, incident management.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Monitor application performance

DETAILS:
**Tier:** Free, Premium, Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

GitLab provides a variety of tools to help operate and maintain
your applications.

## Manage alerts and incidents

GitLab helps reduce alert fatigue for IT responders by providing tools to identify
issues across multiple systems and aggregate alerts in a centralized place. Your
team needs a single, central interface where they can investigate alerts
and promote the critical alerts to incidents.

Are your alerts too noisy? Alerts can be configured
and fine-tuned in GitLab immediately following a fire-fight.

- [Manage alerts and incidents](incident_management/index.md) in GitLab.
- Create a [status page](incident_management/status_page.md)
  to communicate efficiently to your users during an incident.

## Track errors in your application

GitLab integrates with [Sentry](https://sentry.io/welcome/) to aggregate errors
from your application and surface them in the GitLab UI with the sorting and filtering
features you need to help identify which errors are the most critical. Through the
entire triage process, your users can create GitLab issues to track critical errors
and the work required to fix them - all without leaving GitLab.

- Discover and view errors generated by your applications with
  [Error Tracking](error_tracking.md).

## Manage application performance with distributed tracing

GitLab can troubleshoot application performance issues with distributed tracing by inspecting how a request moves through different services and systems, the timing of each operation, and any errors or logs as they occur. You can leverage tracing for your microservice applications, which group multiple independent services collaborating to fulfill user requests.

- See [Distributed tracing](tracing.md).

## Manage your infrastructure in code

GitLab stores and executes your infrastructure as code, whether it's
defined in Ansible, Puppet or Chef. We also offer native integration with
[Terraform](https://www.terraform.io/), uniting your GitOps and
Infrastructure-as-Code (IaC) workflows with the GitLab authentication, authorization,
and user interface. By lowering the barrier to entry for adopting Terraform, you
can manage and provision infrastructure through machine-readable definition files,
rather than physical hardware configuration or interactive configuration tools.
Definitions are stored in version control, extending proven coding techniques to
your infrastructure, and blurring the line between what is an application and what is
an environment.

- Learn how to [manage your infrastructure with GitLab and Terraform](../user/infrastructure/index.md).

## More features

- Deploy to different [environments](../ci/environments/index.md).
- Connect your project to a [Kubernetes cluster](../user/infrastructure/clusters/index.md).
- Create, toggle, and remove [feature flags](feature_flags.md).
