/* xstat.h: stat with error checking.

Copyright (C) 1992, 93 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef KPATHSEA_XSTAT_H
#define KPATHSEA_XSTAT_H

#include <kpathsea/c-proto.h>
#include <kpathsea/c-stat.h>
#include <kpathsea/types.h>

#if defined (OS2) && defined (USE_SYMLINK_HEADERS)
#define S_ISLNK 0
#endif

/* Does stat(2) on PATH, and aborts if the stat fails.  */
extern struct stat xstat P1H(const_string path);

/* Ditto, for lstat(2) (except that lstat might not exist).  */
#ifdef S_ISLNK
extern struct stat xlstat P1H(const_string path);
#else
#define xlstat xstat
#endif

#endif /* not KPATHSEA_XSTAT_H */
