program nappend;

uses
  crt,
  dos;


const
  file_max = 255;
  copyerror : integer = 0;
  bufmax = maxint;

type
  filetype = record
               name : pathstr;
               f_index : file ;
               f_game: file;
             end;


  filename = pathstr;
  filelist = array[1..file_max] of filename;

  buffertype = array[0..bufmax-1] of byte;

var
  sourcepath: pathstr;
  targetpath: pathstr;
  source : array [0..100] of filetype;
  target : filetype;
  buffer, buffer2 : ^buffertype;

function aktual_disk: byte;
var
  regs : registers;
begin
  regs.ah:=$19;
  msdos(regs);
  aktual_disk:=regs.al+1;
end;

function upcasestr(s1: string) : string;
var
  s2: string;
  i : integer;

begin
  s2:='';
  for i:=1 to length(s1) do
    s2:=s2+upcase(s1[i]);
  upcasestr:=s2;
end;

function file_exist (file_name : string): boolean;
var
  f : file;

begin
  {$i-}
  assign(f, file_name);
  reset(f);
  close(f);
  {i+}
  file_exist:=((ioresult=0) and (file_name<>''));
end;

procedure remove_ext(VAR s1 : pathstr);
begin
  while pos('.',s1)>0 do
    s1:=copy(s1,1,length(s1)-1);
end;

procedure io_test;
begin
  copyerror:=ioresult;
  if copyerror=0 then
    if doserror<>0 then
      copyerror:=doserror;
  doserror:=0;
end; {io_test}


procedure plus_backslash(var path: pathstr);
begin
  if path[length(path)]<>'\' then
    path:=path+'\';
end; {plus_backslash}

procedure find_path(VAR search_files, path: pathstr);

begin
  if pos('\',search_files)>0 then
  begin
    path:=search_files;
    while path[length(path)]<>'\' do
      path:=copy(path,1,length(path)-1);
  end
  else
  if pos(':',search_files)>0 then
  begin
    getdir(ord(search_files[1])-64,path);
  end
  else
    getdir(aktual_disk,path);

  plus_backslash(path);
  while (pos(':',search_files)>0) or (pos('\',search_files)>0) do
    search_files:=copy(search_files,2,length(search_files)-1);
  search_files:=upcasestr(search_files);
  path:=upcasestr(path);
end;

procedure getdirlist(searchstr : string; var dirlist : filelist);
const
  search_attr = $2f;

var
  nr : word;
  one_entry : searchrec;


begin
  nr :=1;
  findfirst(searchstr,search_attr,one_entry);
  io_test;
  while (copyerror=0) do
  begin
    dirlist[nr] := one_entry.name;
    nr := succ(nr);
    findnext(one_entry);
    io_test;
  end; {while}
  repeat
    dirlist[nr] := '';
    nr:=succ(nr);
  until nr = file_max;
end;  {getdirlist}

procedure append_one(Var source, target : filetype; VAR begin_pos : longint);
var
  index_pos, index, idx_buf1, idx_buf2 : longint;
  bytes_read, bytes_read2, bytes_written: integer;
  j : byte;
  mini_buf : array[0..3] of byte;
  byte_numb : array[0..3] of longint;

begin
  io_test;
  assign(source.f_index,source.name+'.I30');
  if file_exist(source.name+'.I30') then
  begin
    reset(source.f_index,1);
    io_test;
    index_pos:=begin_pos;
    bytes_read:=1;
    copyerror:=0;
    while (copyerror=0) and (bytes_read>0) do
    begin
      blockread(source.f_index,buffer^,30000,bytes_read);
      io_test;

      if (copyerror=0) and (bytes_read>0) then
      begin
        if (bytes_read mod 4)>0 then
        begin
          blockread(source.f_index,mini_buf,4-(bytes_read mod 4),
                    bytes_read2);
          io_test;
          if (copyerror=0) and (bytes_read2=4-(bytes_read mod 4)) then
          begin
            for j:=1 to bytes_read2 do
              buffer^[bytes_read+j]:=mini_buf[j-1];
            bytes_read:=bytes_read+bytes_read2;
          end
          else
          begin
            writeln('Readerror in ',source.name,'.I30');
            halt;
          end;
        end;
        idx_buf1:=0; idx_buf2:=0;
        while idx_buf1<(bytes_read) do
        begin
          byte_numb[0]:=buffer^[idx_buf1]; inc(idx_buf1);
          byte_numb[1]:=buffer^[idx_buf1]; inc(idx_buf1);
          byte_numb[2]:=buffer^[idx_buf1]; inc(idx_buf1);
          byte_numb[3]:=buffer^[idx_buf1]; inc(idx_buf1);

          index_pos:=begin_pos;

          inc(index_pos,byte_numb[0]*256*256*256);
          inc(index_pos,byte_numb[1]*256*256);
          inc(index_pos,byte_numb[2]*256);
          inc(index_pos,byte_numb[3]);

          if not ((index_pos=begin_pos) and (begin_pos>0)) then
          begin
            index:=index_pos;
            byte_numb[3]:=index mod 256;
            index:=index div 256;
            byte_numb[2]:=index mod 256;
            index:=index div 256;
            byte_numb[1]:=index mod 256;
            index:=index div 256;
            byte_numb[0]:=index mod 256;

            buffer2^[idx_buf2]:=byte_numb[0];   inc(idx_buf2);
            buffer2^[idx_buf2]:=byte_numb[1]; inc(idx_buf2);
            buffer2^[idx_buf2]:=byte_numb[2]; inc(idx_buf2);
            buffer2^[idx_buf2]:=byte_numb[3]; inc(idx_buf2);
          end;
        end;
        blockwrite(target.f_index, buffer2^,idx_buf2, bytes_written);
        io_test;
        write('.');
      end
      else
      if copyerror>0 then
      begin
        writeln('Readerror in ',source.name,'.I30');
        halt;
      end;
    end;
    begin_pos:=index_pos;
    assign(source.f_game, source.name+'.G30');
    if file_exist(source.name+'.G30') then
    begin
      reset(source.f_game,1);
      io_test;
      bytes_read:=1;
      while (copyerror=0) and (bytes_read>0) do
      begin
        blockread(source.f_game, buffer^, bufmax, bytes_read);
        io_test;
        if copyerror=0 then
        begin
          blockwrite(target.f_game, buffer^, bytes_read, bytes_written);
          io_test;
        end;
        if copyerror<>0 then
        begin
          writeln('Error copying gamefiles');
          halt;
        end;
        write('.');
      end;
    end
    else
    begin
      writeln(source.name+'.G30 impossible to open');
      halt;
    end;
  end;
  writeln;
  close(source.f_game);  io_test;
  close(source.f_index); io_test;
end;

var
  i: integer;
  numb_of_source : integer;
  numb_of_games : longint;
  begin_pos : longint;
  f1, f2 : file of byte;
  dir_list : filelist;
  choice : char;
  search_files, source_path, target_path : pathstr;

begin
  io_test;
  
  if paramcount<2 then
  begin
    writeln;
    writeln('SYNTAX: NAPPEND source-wildcard target-filename');
    writeln;
    writeln('EX:     NAPPEND yb* all-yb');
    writeln;
    writeln('Makes a gamefile and an indexfile called all-yb.g30 and all-yb.i30');
    writeln('consisting of all NicBase files starting with yb*.g30 and yb*.i30');
    writeln('If all-yb.* already exists, all new files are appended to it');
    writeln;
    writeln('Carsten Hansen, CH0506@HDC.HHA.DK');
    Writeln;
    writeln('Any comments welcome!');
    writeln;
    write('Type source wildcard: ');
    readln(search_files);
    write('Type target filename: ');
    readln(target.name);
    writeln;
  end
  else
  begin
    search_files:=paramstr(1);
    target.name:=paramstr(2);
  end;
  remove_ext(search_files);
  remove_ext(target.name);
  find_path(search_files, source_path);
  find_path(target.name,  target_path);
  getdirlist(source_path+search_files+'.I30',dir_list);
  writeln;
  source[0].name:=target_path+target.name;
  i:=1;
  while dir_list[i]<>'' do
  begin
    source[i].name:=upcasestr(source_path+
                              copy(dir_list[i],1,pos('.',dir_list[i])-1));
    inc(i);
  end;
  numb_of_source:= i - 1;
  i:=1;
  while (i<=numb_of_source) and (numb_of_source>1) do
  begin
    write(source[i].name);
    gotoxy(65,wherey);
    write('INCLUDE Y/N? ');
    readln(choice);
    if upcase(choice)='N' then
      source[i].name:='';
    inc(i);
  end;
  buffer:=nil;
  buffer2:=nil;
  new(buffer);
  new(buffer2);
  begin_pos := 0;

  assign(target.f_index, target_path+'__target.I30');
  assign(target.f_game,  target_path+'__target.G30');
  if file_exist(target_path+'__target.I30') then
  begin
    erase(target.f_index);
    io_test;
  end;
  rewrite(target.f_index,1); io_test;

  if file_exist(target_path+'__target.G30') then
  begin
    erase(target.f_game);
    io_test;
  end;
  rewrite(target.f_game,1); io_test;
  i:=0;
  while (i<=numb_of_source) and (numb_of_source>0) do
  begin
    if (source[i].name<>'') and file_exist(source[i].name+'.I30') and
       file_exist(source[i].name+'.G30') then
    begin
      if (i=0) or (source[i].name<>source[0].name) then
      begin
        assign(f1,source[i].name+'.I30');
        reset(f1);
        numb_of_games:=(filesize(f1)-4) div 4;
        close(f1);
        if numb_of_games>0 then
        begin
          write(numb_of_games:7,' Games  ');
          write(source[i].name);
          append_one(source[i], target, begin_pos);
        end;
      end;
    end;
    inc(i);
  end;
  dispose(buffer);
  dispose(buffer2);
  numb_of_games:=(filesize(target.f_index)-4) div 4;
  close(target.f_index);
  close(target.f_game);
  if numb_of_games>0 then
  begin
    writeln('=========================================================');
    write(numb_of_games:7,' Games  ');
    writeln(target_path,target.name);
    writeln('=========================================================');
    if file_exist(target_path+target.name+'.I30') and
       file_exist(target_path+target.name+'.G30') then
    begin
      assign(f1,target_path+target.name+'.I30');
      rename(f1,target_path+target.name+'.I--');
      assign(f2,target_path+target.name+'.G30');
      rename(f2,target_path+target.name+'.G--');
      writeln('RENAMING OLD ',target.name,'.I30 ===> ',target.name,'.I--');
      writeln('RENAMING OLD ',target.name,'.G30 ===> ',target.name,'.G--');
    end;
    rename(target.f_index,target_path+target.name+'.I30');
    rename(target.f_game ,target_path+target.name+'.G30');
  end
  else
  begin
    if numb_of_source=0 then
    begin
      writeln;
      writeln('NOT POSSIBLE TO FIND ANY MATCHING FILES');
      writeln;
    end;
    erase(target.f_index);
    erase(target.f_game);
  end;
end.

