/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;

public class RectangleReadOnly
extends Rectangle {
    public RectangleReadOnly(float llx, float lly, float urx, float ury) {
        super(llx, lly, urx, ury);
    }

    public RectangleReadOnly(float urx, float ury) {
        super(0.0f, 0.0f, urx, ury);
    }

    public RectangleReadOnly(Rectangle rect) {
        super(rect.llx, rect.lly, rect.urx, rect.ury);
        super.cloneNonPositionParameters(rect);
    }

    private void throwReadOnlyError() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("rectanglereadonly.this.rectangle.is.read.only"));
    }

    public void setLeft(float llx) {
        this.throwReadOnlyError();
    }

    public void setRight(float urx) {
        this.throwReadOnlyError();
    }

    public void setTop(float ury) {
        this.throwReadOnlyError();
    }

    public void setBottom(float lly) {
        this.throwReadOnlyError();
    }

    public void normalize() {
        this.throwReadOnlyError();
    }

    public void setBackgroundColor(BaseColor value) {
        this.throwReadOnlyError();
    }

    public void setGrayFill(float value) {
        this.throwReadOnlyError();
    }

    public void setBorder(int border) {
        this.throwReadOnlyError();
    }

    public void setUseVariableBorders(boolean useVariableBorders) {
        this.throwReadOnlyError();
    }

    public void enableBorderSide(int side) {
        this.throwReadOnlyError();
    }

    public void disableBorderSide(int side) {
        this.throwReadOnlyError();
    }

    public void setBorderWidth(float borderWidth) {
        this.throwReadOnlyError();
    }

    public void setBorderWidthLeft(float borderWidthLeft) {
        this.throwReadOnlyError();
    }

    public void setBorderWidthRight(float borderWidthRight) {
        this.throwReadOnlyError();
    }

    public void setBorderWidthTop(float borderWidthTop) {
        this.throwReadOnlyError();
    }

    public void setBorderWidthBottom(float borderWidthBottom) {
        this.throwReadOnlyError();
    }

    public void setBorderColor(BaseColor borderColor) {
        this.throwReadOnlyError();
    }

    public void setBorderColorLeft(BaseColor borderColorLeft) {
        this.throwReadOnlyError();
    }

    public void setBorderColorRight(BaseColor borderColorRight) {
        this.throwReadOnlyError();
    }

    public void setBorderColorTop(BaseColor borderColorTop) {
        this.throwReadOnlyError();
    }

    public void setBorderColorBottom(BaseColor borderColorBottom) {
        this.throwReadOnlyError();
    }

    public void cloneNonPositionParameters(Rectangle rect) {
        this.throwReadOnlyError();
    }

    public void softCloneNonPositionParameters(Rectangle rect) {
        this.throwReadOnlyError();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RectangleReadOnly: ");
        buf.append(this.getWidth());
        buf.append('x');
        buf.append(this.getHeight());
        buf.append(" (rot: ");
        buf.append(this.rotation);
        buf.append(" degrees)");
        return buf.toString();
    }
}

