/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.Maketitle;
import java.io.IOException;

public class L2HMaketitle
extends Maketitle {
    public L2HMaketitle() {
        this("maketitle");
    }

    public L2HMaketitle(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HMaketitle(this.getName());
    }

    @Override
    public void preProcess(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        l2HConverter.setCurrentBlockType(DocumentBlockType.HEADING);
        super.preProcess(teXParser);
    }

    @Override
    public void postProcess(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        super.postProcess(teXParser);
        l2HConverter.setCurrentBlockType(DocumentBlockType.BODY);
    }

    @Override
    protected TeXObjectList createTitle(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObjectList teXObjectList = l2HConverter.createStack();
        teXObjectList.add(l2HConverter.newHtml5StartElement("header"));
        StartElement startElement = new StartElement("div");
        startElement.putAttribute("class", "title");
        teXObjectList.add(startElement);
        teXObjectList.add(l2HConverter.getControlSequence("@title"));
        teXObjectList.add(new EndElement("div"));
        teXObjectList.add(new HtmlTag("<!-- end of title -->"));
        ControlSequence controlSequence = l2HConverter.getControlSequence("@subtitle");
        if (!controlSequence.isEmpty()) {
            startElement = new StartElement("div");
            startElement.putAttribute("class", "subtitle");
            teXObjectList.add(startElement);
            teXObjectList.add(controlSequence);
            teXObjectList.add(new EndElement("div"));
            teXObjectList.add(new HtmlTag("<!-- end of subtitle -->"));
        }
        startElement = new StartElement("div");
        startElement.putAttribute("class", "author");
        teXObjectList.add(startElement);
        teXObjectList.add(l2HConverter.getControlSequence("@author"));
        teXObjectList.add(new EndElement("div"));
        teXObjectList.add(new HtmlTag("<!-- end of author -->"));
        startElement = new StartElement("div");
        startElement.putAttribute("class", "date");
        teXObjectList.add(startElement);
        teXObjectList.add(l2HConverter.getControlSequence("@date"));
        teXObjectList.add(new EndElement("div"));
        teXObjectList.add(new HtmlTag("<!-- end of date -->"));
        teXObjectList.add(l2HConverter.newHtml5EndElement("header"));
        return teXObjectList;
    }
}

