## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(printtree)

## -----------------------------------------------------------------------------
tmp <- tempdir()
demo <- file.path(tmp, "printtree-demo")

# Start fresh

if (dir.exists(demo)) unlink(demo, recursive = TRUE, force = TRUE)

dir.create(demo, recursive = TRUE)
dir.create(file.path(demo, "R"))
dir.create(file.path(demo, "data", "raw"), recursive = TRUE)

file.create(file.path(demo, "R", "hello.R"))
file.create(file.path(demo, "README.md"))
file.create(file.path(demo, ".Rhistory"))


## -----------------------------------------------------------------------------
print_rtree()

## -----------------------------------------------------------------------------
file.create(file.path(demo, "DESCRIPTION"))
subdir <- file.path(demo, "data", "raw")
print_rtree(subdir, project = "root")

## -----------------------------------------------------------------------------
print_rtree(subdir,
project = "root",
root_markers = c(".Rproj", "DESCRIPTION", "_quarto.yml"))


## -----------------------------------------------------------------------------
print_rtree(max_depth = 2)


## -----------------------------------------------------------------------------
print_rtree(demo, show_hidden = TRUE, max_depth = 2)


## -----------------------------------------------------------------------------
print_rtree(demo, format = "unicode", max_depth = 2)


## -----------------------------------------------------------------------------
# Save PNG snapshots 
png_light <- tempfile("tree-light-", fileext = ".png")
png_dark  <- tempfile("tree-dark-",  fileext = ".png")

# Light (white bg, black text)
print_rtree(demo, snapshot = TRUE, snapshot_bg = "white", snapshot_file = png_light)

# Dark (black bg, white text)
print_rtree(demo, snapshot = TRUE, snapshot_bg = "black", snapshot_file = png_dark)



