/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.bidiagonal;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.bidiagonal.BidiagonalDecompositionRow_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.BidiagonalDecomposition_F64;
import org.ejml.interfaces.decomposition.QRPDecomposition_F64;

public class BidiagonalDecompositionTall_DDRM
implements BidiagonalDecomposition_F64<DMatrixRMaj> {
    QRPDecomposition_F64<DMatrixRMaj> decompQRP = DecompositionFactory_DDRM.qrp(500, 100);
    BidiagonalDecomposition_F64<DMatrixRMaj> decompBi = new BidiagonalDecompositionRow_DDRM();
    DMatrixRMaj B = new DMatrixRMaj(1, 1);
    int m;
    int n;
    int min;

    public void getDiagonal(double[] diag, double[] off) {
        diag[0] = this.B.get(0);
        for (int i = 1; i < this.n; ++i) {
            diag[i] = this.B.unsafe_get(i, i);
            off[i - 1] = this.B.unsafe_get(i - 1, i);
        }
    }

    public DMatrixRMaj getB(DMatrixRMaj B, boolean compact) {
        B = BidiagonalDecompositionRow_DDRM.handleB(B, compact, this.m, this.n, this.min);
        B.set(0, 0, this.B.get(0, 0));
        for (int i = 1; i < this.min; ++i) {
            B.set(i, i, this.B.get(i, i));
            B.set(i - 1, i, this.B.get(i - 1, i));
        }
        if (this.n > this.m) {
            B.set(this.min - 1, this.min, this.B.get(this.min - 1, this.min));
        }
        return B;
    }

    public DMatrixRMaj getU(DMatrixRMaj U, boolean transpose, boolean compact) {
        U = BidiagonalDecompositionRow_DDRM.handleU(U, false, compact, this.m, this.n, this.min);
        if (compact) {
            DMatrixRMaj Q1 = (DMatrixRMaj)this.decompQRP.getQ(null, true);
            DMatrixRMaj U1 = (DMatrixRMaj)this.decompBi.getU(null, false, true);
            CommonOps_DDRM.mult((DMatrix1Row)Q1, (DMatrix1Row)U1, (DMatrix1Row)U);
        } else {
            DMatrixRMaj Q = (DMatrixRMaj)this.decompQRP.getQ((Matrix)U, false);
            DMatrixRMaj U1 = (DMatrixRMaj)this.decompBi.getU(null, false, true);
            DMatrixRMaj Q1 = CommonOps_DDRM.extract(Q, 0, Q.numRows, 0, this.min);
            DMatrixRMaj tmp = new DMatrixRMaj(Q1.numRows, U1.numCols);
            CommonOps_DDRM.mult((DMatrix1Row)Q1, (DMatrix1Row)U1, (DMatrix1Row)tmp);
            CommonOps_DDRM.insert((DMatrix)tmp, (DMatrix)Q, 0, 0);
        }
        if (transpose) {
            CommonOps_DDRM.transpose(U);
        }
        return U;
    }

    public DMatrixRMaj getV(DMatrixRMaj V, boolean transpose, boolean compact) {
        return (DMatrixRMaj)this.decompBi.getV((Matrix)V, transpose, compact);
    }

    public boolean decompose(DMatrixRMaj orig) {
        if (!this.decompQRP.decompose((Matrix)orig)) {
            return false;
        }
        this.m = orig.numRows;
        this.n = orig.numCols;
        this.min = Math.min(this.m, this.n);
        this.B.reshape(this.min, this.n, false);
        this.decompQRP.getR((Matrix)this.B, true);
        DMatrixRMaj result = new DMatrixRMaj(this.min, this.n);
        DMatrixRMaj P = (DMatrixRMaj)this.decompQRP.getColPivotMatrix(null);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.B, (DMatrix1Row)P, (DMatrix1Row)result);
        this.B.set((DMatrixD1)result);
        return this.decompBi.decompose((Matrix)this.B);
    }

    public boolean inputModified() {
        return this.decompQRP.inputModified();
    }
}

