### Name: download.packages2
### Title: A function to download packages from a reposTools repository
### Aliases: download.packages2
### Keywords: utilities

### ** Examples

   tmpLib <- tempfile()
   dir.create(tmpLib)

   z <- getReposEntry("http://www.bioconductor.org/repository/sample/package")
   download.packages2(c("annotate", "geneplotter"), z, destDir=tmpLib)

   ## A more 'real world' example
   if (interactive()) {
       ## Using the repositories function will allow you to select
       ## a repository out of the known possibilities.  The return
       ## value is a repEntry object which can be used for download.packages2
       z <- repositories()
       download.packages2("Biobase", z, destDir=tmpLib)
   }

   



