### Name: getSYMBOL
### Title: Functions to deal with Data Packages
### Aliases: getSYMBOL getGO getGOdesc getPMID getLL lookUp getUniqAnnItem
### Keywords: manip

### ** Examples

  data(eset)
  gN <- geneNames(eset)[100:105]
   ## A bit of a hack to not have a package dependency on hgu95av2
   ## but need to fiddle w/ the warn level to not fail the example anyways.
   curWarn <- getOption("warn")
   options(warn=0)
   on.exit(options(warn=curWarn), add=TRUE)
  if( require("hgu95av2", character.only=TRUE)
       && require("GO", character.only=TRUE) ) {
      lookUp(gN, "hgu95av2", "SYMBOL")
      # Same as lookUp for SYMBOL except the return is a vector
      getSYMBOL(gN,"hgu95av2" )
      gg<- getGO(gN, "hgu95av2")
      lookUp(gg[[2]][[1]][["GOID"]], "GO", "TERM")
      # Same as lookUp for TERM
      getGOdesc(gg[[2]][[1]][["GOID"]], "ANY")
      # For BP only
      getGOdesc(gg[[2]][[1]][["GOID"]], "BP")
      getLL(gN, "hgu95av2")
      getPMID(gN, "hgu95av2")
  } else
   cat("could not run all examples\n")



